/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

public class BigDecimalColumnGetter
extends AbstractColumnGetter {
    protected BigDecimal value;

    public BigDecimalColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getBigDecimal(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.DOUBLE;
    }

    @Override
    public void booleanColumn(Column column) {
        this.to.setBoolean(column, this.value.signum() > 0);
    }

    @Override
    public void longColumn(Column column) {
        this.to.setLong(column, this.value.longValue());
    }

    @Override
    public void doubleColumn(Column column) {
        double rounded = this.value.doubleValue();
        this.to.setDouble(column, rounded);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, this.value.toPlainString());
    }
}

