/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

public class BooleanColumnGetter
extends AbstractColumnGetter {
    protected boolean value;

    public BooleanColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getBoolean(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.BOOLEAN;
    }

    @Override
    public void booleanColumn(Column column) {
        this.to.setBoolean(column, this.value);
    }

    @Override
    public void longColumn(Column column) {
        this.to.setLong(column, this.value ? 1L : 0L);
    }

    @Override
    public void doubleColumn(Column column) {
        this.to.setDouble(column, this.value ? 1.0 : 0.0);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, Boolean.toString(this.value));
    }
}

