/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.lang.reflect.Field;
import java.sql.Types;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.embulk.config.ConfigException;
import org.embulk.input.jdbc.AbstractJdbcInputPlugin;
import org.embulk.input.jdbc.JdbcColumn;
import org.embulk.input.jdbc.JdbcColumnOption;
import org.embulk.input.jdbc.JdbcInputConnection;
import org.embulk.input.jdbc.getter.BigDecimalColumnGetter;
import org.embulk.input.jdbc.getter.BooleanColumnGetter;
import org.embulk.input.jdbc.getter.ColumnGetter;
import org.embulk.input.jdbc.getter.DateColumnGetter;
import org.embulk.input.jdbc.getter.DoubleColumnGetter;
import org.embulk.input.jdbc.getter.FloatColumnGetter;
import org.embulk.input.jdbc.getter.JsonColumnGetter;
import org.embulk.input.jdbc.getter.LongColumnGetter;
import org.embulk.input.jdbc.getter.StringColumnGetter;
import org.embulk.input.jdbc.getter.TimeColumnGetter;
import org.embulk.input.jdbc.getter.TimestampColumnGetter;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.TimestampType;
import org.embulk.spi.type.Type;
import org.embulk.util.timestamp.TimestampFormatter;

public class ColumnGetterFactory {
    protected final PageBuilder to;
    private final ZoneId defaultTimeZone;
    private final Map<Integer, String> jdbcTypes = this.getAllJDBCTypes();

    public ColumnGetterFactory(PageBuilder to, ZoneId defaultTimeZone) {
        this.to = to;
        this.defaultTimeZone = defaultTimeZone;
    }

    public ColumnGetter newColumnGetter(JdbcInputConnection con, AbstractJdbcInputPlugin.PluginTask task, JdbcColumn column, JdbcColumnOption option) {
        return this.newColumnGetter(con, task, column, option, option.getValueType());
    }

    private ColumnGetter newColumnGetter(JdbcInputConnection con, AbstractJdbcInputPlugin.PluginTask task, JdbcColumn column, JdbcColumnOption option, String valueType) {
        Type toType = this.getToType(option);
        switch (valueType) {
            case "coalesce": {
                return this.newColumnGetter(con, task, column, option, this.sqlTypeToValueType(column, column.getSqlType()));
            }
            case "long": {
                return new LongColumnGetter(this.to, toType);
            }
            case "float": {
                return new FloatColumnGetter(this.to, toType);
            }
            case "double": {
                return new DoubleColumnGetter(this.to, toType);
            }
            case "boolean": {
                return new BooleanColumnGetter(this.to, toType);
            }
            case "string": {
                return new StringColumnGetter(this.to, toType);
            }
            case "json": {
                return new JsonColumnGetter(this.to, toType);
            }
            case "date": {
                return new DateColumnGetter(this.to, toType, this.newTimestampFormatter(option, "%Y-%m-%d"));
            }
            case "time": {
                return new TimeColumnGetter(this.to, toType, this.newTimestampFormatter(option, "%Y-%m-%d"));
            }
            case "timestamp": {
                return new TimestampColumnGetter(this.to, toType, this.newTimestampFormatter(option, "%Y-%m-%d"));
            }
            case "decimal": {
                return new BigDecimalColumnGetter(this.to, toType);
            }
        }
        throw new ConfigException(String.format(Locale.ENGLISH, "Unknown value_type '%s' for column '%s'", option.getValueType(), column.getName()));
    }

    protected Map<Integer, String> getAllJDBCTypes() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Field f : Types.class.getFields()) {
            try {
                map.put((Integer)f.get(null), f.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return map;
    }

    public String getJdbcType(int sqlType) {
        return this.jdbcTypes.get(sqlType);
    }

    protected String sqlTypeToValueType(JdbcColumn column, int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "long";
            }
            case 6: 
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case -7: 
            case 16: {
                return "boolean";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "string";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case 2: 
            case 3: {
                return "decimal";
            }
        }
        throw ColumnGetterFactory.unsupportedOperationException(column);
    }

    protected Type getToType(JdbcColumnOption option) {
        if (!option.getType().isPresent()) {
            return null;
        }
        Type toType = option.getType().get();
        if (toType instanceof TimestampType && option.getTimestampFormat().isPresent()) {
            toType = ((TimestampType)toType).withFormat(option.getTimestampFormat().get());
        }
        return toType;
    }

    private TimestampFormatter newTimestampFormatter(JdbcColumnOption option, String defaultTimestampFormat) {
        String format = option.getTimestampFormat().orElse(defaultTimestampFormat);
        ZoneId timezone = option.getTimeZone().orElse(this.defaultTimeZone);
        return TimestampFormatter.builder((String)format, (boolean)true).setDefaultZoneId(timezone).build();
    }

    private static UnsupportedOperationException unsupportedOperationException(JdbcColumn column) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unsupported type %s (sqlType=%d) of '%s' column. Please add '%s: {value_type: string}' to 'column_options: {...}' option to convert the values to strings, or exclude the column from 'select:' option", column.getTypeName(), column.getSqlType(), column.getName(), column.getName()));
    }
}

