/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

public class FloatColumnGetter
extends AbstractColumnGetter {
    protected float value;

    public FloatColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getFloat(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.DOUBLE;
    }

    @Override
    public void booleanColumn(Column column) {
        this.to.setBoolean(column, (double)this.value > 0.0);
    }

    @Override
    public void longColumn(Column column) {
        long l;
        try {
            l = this.roundFloatToLong(this.value);
        }
        catch (ArithmeticException e) {
            super.longColumn(column);
            return;
        }
        this.to.setLong(column, l);
    }

    @Override
    public void doubleColumn(Column column) {
        this.to.setDouble(column, (double)this.value);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, Float.toString(this.value));
    }
}

