/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonParser;
import org.msgpack.value.Value;

public class JsonColumnGetter
extends AbstractColumnGetter {
    protected final JsonParser jsonParser = new JsonParser();
    protected String value;

    public JsonColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getString(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.JSON;
    }

    @Override
    public void jsonColumn(Column column) {
        Value v;
        try {
            v = this.jsonParser.parse(this.value);
        }
        catch (JsonParseException e) {
            super.jsonColumn(column);
            return;
        }
        this.to.setJson(column, v);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, this.value);
    }
}

