/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

public class LongColumnGetter
extends AbstractColumnGetter {
    protected long value;

    public LongColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getLong(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.LONG;
    }

    @Override
    public void booleanColumn(Column column) {
        this.to.setBoolean(column, this.value > 0L);
    }

    @Override
    public void longColumn(Column column) {
        this.to.setLong(column, this.value);
    }

    @Override
    public void doubleColumn(Column column) {
        this.to.setDouble(column, (double)this.value);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, Long.toString(this.value));
    }

    @Override
    public JsonNode encodeToJson() {
        return jsonNodeFactory.numberNode(this.value);
    }

    @Override
    public void decodeFromJsonTo(PreparedStatement toStatement, int toIndex, JsonNode fromValue) throws SQLException {
        toStatement.setLong(toIndex, fromValue.asLong());
    }
}

