/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.embulk.input.jdbc.getter.AbstractColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonParser;
import org.msgpack.value.Value;

public class StringColumnGetter
extends AbstractColumnGetter {
    protected final JsonParser jsonParser = new JsonParser();
    protected String value;

    public StringColumnGetter(PageBuilder to, Type toType) {
        super(to, toType);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        this.value = from.getString(fromIndex);
    }

    @Override
    protected Type getDefaultToType() {
        return Types.STRING;
    }

    @Override
    public void longColumn(Column column) {
        long l;
        try {
            l = Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            super.longColumn(column);
            return;
        }
        this.to.setLong(column, l);
    }

    @Override
    public void doubleColumn(Column column) {
        double d;
        try {
            d = Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            super.doubleColumn(column);
            return;
        }
        this.to.setDouble(column, d);
    }

    @Override
    public void jsonColumn(Column column) {
        Value v;
        try {
            v = this.jsonParser.parse(this.value);
        }
        catch (JsonParseException e) {
            super.jsonColumn(column);
            return;
        }
        this.to.setJson(column, v);
    }

    @Override
    public void stringColumn(Column column) {
        this.to.setString(column, this.value);
    }

    @Override
    public JsonNode encodeToJson() {
        return jsonNodeFactory.textNode(this.value);
    }

    @Override
    public void decodeFromJsonTo(PreparedStatement toStatement, int toIndex, JsonNode fromValue) throws SQLException {
        toStatement.setString(toIndex, fromValue.asText());
    }
}

