/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.embulk.input.jdbc.getter.AbstractTimestampColumnGetter;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.embulk.util.timestamp.TimestampFormatter;

public class TimestampColumnGetter
extends AbstractTimestampColumnGetter {
    static final String DEFAULT_FORMAT = "%Y-%m-%d %H:%M:%S";

    public TimestampColumnGetter(PageBuilder to, Type toType, TimestampFormatter timestampFormatter) {
        super(to, toType, timestampFormatter);
    }

    @Override
    protected void fetch(ResultSet from, int fromIndex) throws SQLException {
        Timestamp timestamp = from.getTimestamp(fromIndex);
        if (timestamp != null) {
            this.value = timestamp.toInstant();
        }
    }

    @Override
    protected Type getDefaultToType() {
        return Types.TIMESTAMP.withFormat(DEFAULT_FORMAT);
    }
}

