/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.embulk.config.ConfigException;
import org.embulk.input.jdbc.getter.AbstractIncrementalHandler;
import org.embulk.input.jdbc.getter.ColumnGetter;
import org.embulk.spi.Column;
import org.embulk.util.timestamp.TimestampFormatter;

public class TimestampWithTimeZoneIncrementalHandler
extends AbstractIncrementalHandler {
    private static final TimestampFormatter FORMATTER = TimestampFormatter.builderWithRuby((String)"%Y-%m-%dT%H:%M:%S.%6NZ").build();
    private static final TimestampFormatter PARSER = TimestampFormatter.builderWithRuby((String)"%Y-%m-%dT%H:%M:%S.%N%z").build();
    private long epochSecond;
    private int nano;

    public TimestampWithTimeZoneIncrementalHandler(ColumnGetter next) {
        super(next);
    }

    @Override
    public void getAndSet(ResultSet from, int fromIndex, Column toColumn) throws SQLException {
        Timestamp timestamp = from.getTimestamp(fromIndex);
        if (timestamp != null) {
            this.epochSecond = timestamp.getTime() / 1000L;
            this.nano = timestamp.getNanos();
        }
        super.getAndSet(from, fromIndex, toColumn);
    }

    @Override
    public JsonNode encodeToJson() {
        return jsonNodeFactory.textNode(this.format(this.epochSecond, this.nano));
    }

    private String format(long epochSecond, int nano) {
        return FORMATTER.format(Instant.ofEpochSecond(epochSecond, nano));
    }

    @Override
    public void decodeFromJsonTo(PreparedStatement toStatement, int toIndex, JsonNode fromValue) throws SQLException {
        try {
            Instant epoch = PARSER.parse(fromValue.asText());
            Timestamp sqlTimestamp = Timestamp.from(epoch);
            sqlTimestamp.setNanos(epoch.getNano());
            toStatement.setTimestamp(toIndex, sqlTimestamp);
        }
        catch (DateTimeParseException e) {
            long now = System.currentTimeMillis();
            String sample = this.format(now / 1000L, (int)(now % 1000L * 1000000L));
            throw new ConfigException("Invalid timestamp with time zone pattern: " + fromValue + ". The pattern must be 'yyyy-MM-ddTHH:mm:ss.SSSSSSZ'. e.g. \"" + sample + "\" or \"" + sample.replace("Z", "+0000") + "\"");
        }
    }
}

