/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.time.Instant;
import org.embulk.config.Config;
import org.embulk.config.ConfigSource;
import org.embulk.config.Task;
import org.embulk.config.TaskSource;
import org.embulk.spi.Buffer;
import org.embulk.spi.Column;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.ParserPlugin;
import org.embulk.spi.Schema;
import org.embulk.spi.SchemaConfig;
import org.embulk.spi.json.JsonParser;
import org.embulk.spi.type.Type;

public class MockParserPlugin
implements ParserPlugin {
    public static boolean raiseException = false;

    public void transaction(ConfigSource config, ParserPlugin.Control control) {
        PluginTask task = (PluginTask)config.loadConfig(PluginTask.class);
        control.run(task.dump(), task.getSchemaConfig().toSchema());
    }

    public void run(TaskSource taskSource, Schema schema, FileInput input, PageOutput output) {
        try (PageBuilder pageBuilder = new PageBuilder(Exec.getBufferAllocator(), schema, output);){
            while (input.nextFile()) {
                Buffer buffer = input.poll();
                if (buffer == null) continue;
                block26: for (Column column : schema.getColumns()) {
                    Type type = column.getType();
                    switch (type.getName()) {
                        case "boolean": {
                            pageBuilder.setBoolean(column, true);
                            continue block26;
                        }
                        case "long": {
                            pageBuilder.setLong(column, 2L);
                            continue block26;
                        }
                        case "double": {
                            pageBuilder.setDouble(column, 3.0);
                            continue block26;
                        }
                        case "string": {
                            pageBuilder.setString(column, "45");
                            continue block26;
                        }
                        case "timestamp": {
                            pageBuilder.setTimestamp(column, Instant.ofEpochMilli(678L));
                            continue block26;
                        }
                        case "json": {
                            pageBuilder.setJson(column, new JsonParser().parse("{\"_c1\":true,\"_c2\":10,\"_c3\":\"embulk\",\"_c4\":{\"k\":\"v\"}}"));
                            continue block26;
                        }
                    }
                    throw new IllegalStateException("Unknown type: " + type.getName());
                }
                pageBuilder.addRecord();
                if (!raiseException) continue;
                throw new RuntimeException("emulated exception");
            }
            pageBuilder.finish();
        }
    }

    public static interface PluginTask
    extends Task {
        @Config(value="columns")
        public SchemaConfig getSchemaConfig();
    }
}

