/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.embulk.EmbulkSystemProperties;
import org.embulk.config.TaskReport;
import org.embulk.exec.BulkLoader;
import org.embulk.exec.ExecutionResult;
import org.embulk.exec.ResumeState;
import org.embulk.spi.ExecInternal;
import org.embulk.spi.ExecSessionInternal;
import org.embulk.spi.Schema;
import org.embulk.test.TestingEmbulk;
import org.slf4j.Logger;

class TestingBulkLoader
extends BulkLoader {
    public TestingBulkLoader(EmbulkSystemProperties embulkSystemProperties) {
        super(embulkSystemProperties);
    }

    protected BulkLoader.LoaderState newLoaderState(Logger logger, BulkLoader.ProcessPluginSet plugins) {
        return new TestingLoaderState(logger, plugins);
    }

    static class TestingExecutionResult
    extends ExecutionResult
    implements TestingEmbulk.RunResult {
        private final Schema inputSchema;
        private final Schema outputSchema;
        private final List<TaskReport> inputTaskReports;
        private final List<TaskReport> outputTaskReports;

        public TestingExecutionResult(ExecutionResult orig, ResumeState resumeState, ExecSessionInternal session) {
            super(orig.getConfigDiff(), orig.isSkipped(), orig.getIgnoredExceptions());
            this.inputSchema = resumeState.getInputSchema();
            this.outputSchema = resumeState.getOutputSchema();
            this.inputTaskReports = TestingExecutionResult.buildReports(resumeState.getInputTaskReports(), session);
            this.outputTaskReports = TestingExecutionResult.buildReports(resumeState.getOutputTaskReports(), session);
        }

        private static List<TaskReport> buildReports(List<Optional<TaskReport>> optionalReports, ExecSessionInternal session) {
            ArrayList<TaskReport> reports = new ArrayList<TaskReport>();
            for (Optional<TaskReport> report : optionalReports) {
                reports.add(report.orElse(session.newTaskReport()));
            }
            return Collections.unmodifiableList(reports);
        }

        @Override
        public Schema getInputSchema() {
            return this.inputSchema;
        }

        @Override
        public Schema getOutputSchema() {
            return this.outputSchema;
        }

        @Override
        public List<TaskReport> getInputTaskReports() {
            return this.inputTaskReports;
        }

        @Override
        public List<TaskReport> getOutputTaskReports() {
            return this.outputTaskReports;
        }
    }

    protected static class TestingLoaderState
    extends BulkLoader.LoaderState {
        public TestingLoaderState(Logger logger, BulkLoader.ProcessPluginSet plugins) {
            super(logger, plugins);
        }

        public ExecutionResult buildExecuteResultWithWarningException(Throwable ex) {
            ExecutionResult result = super.buildExecuteResultWithWarningException(ex);
            return new TestingExecutionResult(result, this.buildResumeState(ExecInternal.sessionInternal()), ExecInternal.sessionInternal());
        }
    }
}

