/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.Buffer;
import org.embulk.spi.FileOutputPlugin;
import org.embulk.spi.TransactionalFileOutput;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileOutputPlugin
implements FileOutputPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Logger logger = LoggerFactory.getLogger(LocalFileOutputPlugin.class);

    public ConfigDiff transaction(ConfigSource config, int taskCount, FileOutputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        try {
            String string = String.format(Locale.ENGLISH, task.getSequenceFormat(), 0, 0);
        }
        catch (IllegalFormatException ex) {
            throw new ConfigException("Invalid sequence_format: parameter for file output plugin", (Throwable)ex);
        }
        return this.resume(task.dump(), taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, int taskCount, FileOutputPlugin.Control control) {
        control.run(taskSource);
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    public void cleanup(TaskSource taskSource, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TransactionalFileOutput open(TaskSource taskSource, final int taskIndex) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        final String pathPrefix = task.getPathPrefix();
        final String pathSuffix = task.getFileNameExtension();
        final String sequenceFormat = task.getSequenceFormat();
        return new TransactionalFileOutput(){
            private final List<String> fileNames = new ArrayList<String>();
            private int fileIndex = 0;
            private FileOutputStream output = null;

            public void nextFile() {
                this.closeFile();
                String path = pathPrefix + String.format(sequenceFormat, taskIndex, this.fileIndex) + pathSuffix;
                logger.info("Writing local file '{}'", (Object)path);
                this.fileNames.add(path);
                try {
                    this.output = new FileOutputStream(new File(path));
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                ++this.fileIndex;
            }

            private void closeFile() {
                if (this.output != null) {
                    try {
                        this.output.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }

            public void add(Buffer buffer) {
                try {
                    this.output.write(buffer.array(), buffer.offset(), buffer.limit());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    buffer.release();
                }
            }

            public void finish() {
                this.closeFile();
            }

            public void close() {
                this.closeFile();
            }

            public void abort() {
            }

            public TaskReport commit() {
                TaskReport report = CONFIG_MAPPER_FACTORY.newTaskReport();
                return report;
            }
        };
    }

    public static interface PluginTask
    extends Task {
        @Config(value="path_prefix")
        public String getPathPrefix();

        @Config(value="file_ext")
        public String getFileNameExtension();

        @Config(value="sequence_format")
        @ConfigDefault(value="\"%03d.%02d.\"")
        public String getSequenceFormat();
    }
}

