/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.embulk.output.jdbc.AbstractJdbcOutputPlugin;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.JdbcOutputConnector;
import org.embulk.output.jdbc.MergeConfig;
import org.embulk.output.jdbc.StandardBatchInsert;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;

public class JdbcOutputPlugin
extends AbstractJdbcOutputPlugin {
    @Override
    protected Class<? extends AbstractJdbcOutputPlugin.PluginTask> getTaskClass() {
        return GenericPluginTask.class;
    }

    @Override
    protected AbstractJdbcOutputPlugin.Features getFeatures(AbstractJdbcOutputPlugin.PluginTask task) {
        GenericPluginTask t = (GenericPluginTask)task;
        return new AbstractJdbcOutputPlugin.Features().setMaxTableNameLength(t.getMaxTableNameLength()).setSupportedModes(Collections.unmodifiableSet(new HashSet<AbstractJdbcOutputPlugin.Mode>(Arrays.asList(AbstractJdbcOutputPlugin.Mode.INSERT, AbstractJdbcOutputPlugin.Mode.INSERT_DIRECT, AbstractJdbcOutputPlugin.Mode.TRUNCATE_INSERT, AbstractJdbcOutputPlugin.Mode.REPLACE))));
    }

    @Override
    protected GenericOutputConnector getConnector(AbstractJdbcOutputPlugin.PluginTask task, boolean retryableMetadataOperation) {
        GenericPluginTask t = (GenericPluginTask)task;
        if (t.getDriverPath().isPresent()) {
            this.addDriverJarToClasspath(t.getDriverPath().get());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)t.getOptions());
        if (t.getUser().isPresent()) {
            props.setProperty("user", t.getUser().get());
        }
        if (t.getPassword().isPresent()) {
            props.setProperty("password", t.getPassword().get());
        }
        this.logConnectionProperties(t.getUrl(), props);
        return new GenericOutputConnector(t.getUrl(), props, t.getDriverClass(), t.getSchema().orElse(null));
    }

    @Override
    protected BatchInsert newBatchInsert(AbstractJdbcOutputPlugin.PluginTask task, Optional<MergeConfig> mergeConfig) throws IOException, SQLException {
        return new StandardBatchInsert(this.getConnector(task, true), mergeConfig);
    }

    private static class GenericOutputConnector
    implements JdbcOutputConnector {
        private final Driver driver;
        private final String url;
        private final Properties properties;
        private final String schemaName;

        public GenericOutputConnector(String url, Properties properties, String driverClass, String schemaName) {
            try {
                this.driver = (Driver)Class.forName(driverClass).newInstance();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.url = url;
            this.properties = properties;
            this.schemaName = schemaName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JdbcOutputConnection connect(boolean autoCommit) throws SQLException {
            try (Connection c = this.driver.connect(this.url, this.properties);){
                c.setAutoCommit(autoCommit);
                JdbcOutputConnection con = new JdbcOutputConnection(c, this.schemaName);
                c = null;
                JdbcOutputConnection jdbcOutputConnection = con;
                return jdbcOutputConnection;
            }
        }
    }

    public static interface GenericPluginTask
    extends AbstractJdbcOutputPlugin.PluginTask {
        @Config(value="driver_path")
        @ConfigDefault(value="null")
        public Optional<String> getDriverPath();

        @Config(value="driver_class")
        public String getDriverClass();

        @Config(value="url")
        public String getUrl();

        @Config(value="user")
        @ConfigDefault(value="null")
        public Optional<String> getUser();

        @Config(value="password")
        @ConfigDefault(value="null")
        public Optional<String> getPassword();

        @Config(value="schema")
        @ConfigDefault(value="null")
        public Optional<String> getSchema();

        @Config(value="max_table_name_length")
        @ConfigDefault(value="30")
        public int getMaxTableNameLength();
    }
}

