/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.Module;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.JdbcColumnOption;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.JdbcOutputConnector;
import org.embulk.output.jdbc.JdbcSchema;
import org.embulk.output.jdbc.JdbcUtils;
import org.embulk.output.jdbc.MergeConfig;
import org.embulk.output.jdbc.PageReaderRecord;
import org.embulk.output.jdbc.Record;
import org.embulk.output.jdbc.TableIdentifier;
import org.embulk.output.jdbc.ToStringMap;
import org.embulk.output.jdbc.TransactionIsolation;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.ColumnSetterFactory;
import org.embulk.output.jdbc.setter.ColumnSetterVisitor;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.OutputPlugin;
import org.embulk.spi.Page;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.TransactionalPageOutput;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapper;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskMapper;
import org.embulk.util.config.modules.ZoneIdModule;
import org.embulk.util.retryhelper.RetryExecutor;
import org.embulk.util.retryhelper.RetryGiveupException;
import org.embulk.util.retryhelper.Retryable;
import org.msgpack.core.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcOutputPlugin
implements OutputPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJdbcOutputPlugin.class);
    protected static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().addModule((Module)ZoneIdModule.withLegacyNames()).build();
    protected static final ConfigMapper CONFIG_MAPPER = CONFIG_MAPPER_FACTORY.createConfigMapper();
    protected static final TaskMapper TASK_MAPPER = CONFIG_MAPPER_FACTORY.createTaskMapper();

    protected void addDriverJarToClasspath(String glob) {
        Method addPathMethod;
        ClassLoader loader = this.getClass().getClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            throw new RuntimeException("Plugin is not loaded by URLClassLoader unexpectedly.");
        }
        if (!"org.embulk.plugin.PluginClassLoader".equals(loader.getClass().getName())) {
            throw new RuntimeException("Plugin is not loaded by PluginClassLoader unexpectedly.");
        }
        Path path = Paths.get(glob, new String[0]);
        if (!path.toFile().exists()) {
            throw new ConfigException("The specified driver jar doesn't exist: " + glob);
        }
        try {
            addPathMethod = loader.getClass().getMethod("addPath", Path.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Plugin is not loaded a ClassLoader which has addPath(Path), unexpectedly.");
        }
        try {
            addPathMethod.invoke((Object)loader, Paths.get(glob, new String[0]));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof MalformedURLException) {
                throw new IllegalArgumentException(targetException);
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException(targetException);
        }
    }

    protected void loadDriver(String className, Optional<String> driverPath) {
        if (driverPath.isPresent()) {
            this.addDriverJarToClasspath(driverPath.get());
        } else {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                File root = AbstractJdbcOutputPlugin.findPluginRoot(this.getClass());
                File driverLib = new File(root, "default_jdbc_driver");
                File[] files = driverLib.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getName().endsWith(".jar");
                    }
                });
                if (files == null || files.length == 0) {
                    throw new RuntimeException("Cannot find JDBC driver in '" + root.getAbsolutePath() + "'.");
                }
                for (File file : files) {
                    logger.info("JDBC Driver = " + file.getAbsolutePath());
                    this.addDriverJarToClasspath(file.getAbsolutePath());
                }
            }
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void logConnectionProperties(String url, Properties props) {
        Properties maskedProps = new Properties();
        for (String key : props.stringPropertyNames()) {
            if (key.equals("password")) {
                maskedProps.setProperty(key, "***");
                continue;
            }
            maskedProps.setProperty(key, props.getProperty(key));
        }
        logger.info("Connecting to {} options {}", (Object)url, (Object)maskedProps);
    }

    protected Class<? extends PluginTask> getTaskClass() {
        return PluginTask.class;
    }

    protected abstract Features getFeatures(PluginTask var1);

    protected abstract JdbcOutputConnector getConnector(PluginTask var1, boolean var2);

    protected abstract BatchInsert newBatchInsert(PluginTask var1, Optional<MergeConfig> var2) throws IOException, SQLException;

    protected JdbcOutputConnection newConnection(PluginTask task, boolean retryableMetadataOperation, boolean autoCommit) throws SQLException {
        return this.getConnector(task, retryableMetadataOperation).connect(autoCommit);
    }

    public ConfigDiff transaction(ConfigSource config, Schema schema, int taskCount, OutputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER.map(config, this.getTaskClass());
        Features features = this.getFeatures(task);
        task.setFeatures(features);
        if (!features.getSupportedModes().contains((Object)task.getMode())) {
            throw new ConfigException(String.format("This output type doesn't support '%s'. Supported modes are: %s", new Object[]{task.getMode(), features.getSupportedModes()}));
        }
        task = this.begin(task, schema, taskCount);
        control.run(task.dump());
        return this.commit(task, schema, taskCount);
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, OutputPlugin.Control control) {
        PluginTask task = (PluginTask)TASK_MAPPER.map(taskSource, this.getTaskClass());
        if (!task.getMode().tempTablePerTask()) {
            throw new UnsupportedOperationException("inplace mode is not resumable. You need to delete partially-loaded records from the database and restart the entire transaction.");
        }
        task = this.begin(task, schema, taskCount);
        control.run(task.dump());
        return this.commit(task, schema, taskCount);
    }

    private PluginTask begin(final PluginTask task, final Schema schema, final int taskCount) {
        try {
            this.withRetry(task, new IdempotentSqlRunnable(){

                @Override
                public void run() throws SQLException {
                    con.showDriverVersion();
                    try (JdbcOutputConnection con = AbstractJdbcOutputPlugin.this.newConnection(task, true, false);){
                        AbstractJdbcOutputPlugin.this.doBegin(con, task, schema, taskCount);
                    }
                }
            });
        }
        catch (InterruptedException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        return task;
    }

    private ConfigDiff commit(final PluginTask task, Schema schema, final int taskCount) {
        if (!task.getMode().isDirectModify() || task.getAfterLoad().isPresent()) {
            try {
                this.withRetry(task, new IdempotentSqlRunnable(){

                    @Override
                    public void run() throws SQLException {
                        try (JdbcOutputConnection con = AbstractJdbcOutputPlugin.this.newConnection(task, false, false);){
                            AbstractJdbcOutputPlugin.this.doCommit(con, task, taskCount);
                        }
                    }
                });
            }
            catch (InterruptedException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    public void cleanup(TaskSource taskSource, Schema schema, final int taskCount, final List<TaskReport> successTaskReports) {
        final PluginTask task = (PluginTask)TASK_MAPPER.map(taskSource, this.getTaskClass());
        if (!task.getMode().isDirectModify()) {
            try {
                this.withRetry(task, new IdempotentSqlRunnable(){

                    @Override
                    public void run() throws SQLException {
                        try (JdbcOutputConnection con = AbstractJdbcOutputPlugin.this.newConnection(task, true, true);){
                            AbstractJdbcOutputPlugin.this.doCleanup(con, task, taskCount, successTaskReports);
                        }
                    }
                });
            }
            catch (InterruptedException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void doBegin(JdbcOutputConnection con, PluginTask task, final Schema schema, int taskCount) throws SQLException {
        JdbcSchema targetTableSchema;
        String actualTable;
        if (schema.getColumnCount() == 0) {
            throw new ConfigException("No column.");
        }
        Mode mode = task.getMode();
        logger.info("Using {} mode", (Object)mode);
        if (mode.commitBySwapTable() && task.getBeforeLoad().isPresent()) {
            throw new ConfigException(String.format("%s mode does not support 'before_load' option.", new Object[]{mode}));
        }
        if (con.tableExists(task.getTable())) {
            actualTable = task.getTable();
        } else {
            String upperTable = task.getTable().toUpperCase();
            String lowerTable = task.getTable().toLowerCase();
            if (con.tableExists(upperTable)) {
                if (con.tableExists(lowerTable)) {
                    throw new ConfigException(String.format("Cannot specify table '%s' because both '%s' and '%s' exist.", task.getTable(), upperTable, lowerTable));
                }
                actualTable = upperTable;
            } else {
                actualTable = con.tableExists(lowerTable) ? lowerTable : task.getTable();
            }
        }
        task.setActualTable(new TableIdentifier(null, con.getSchemaName(), actualTable));
        Optional<JdbcSchema> initialTargetTableSchema = mode.ignoreTargetTableSchema() ? Optional.empty() : this.newJdbcSchemaFromTableIfExists(con, task.getActualTable());
        JdbcSchema newTableSchema = AbstractJdbcOutputPlugin.applyColumnOptionsToNewTableSchema(initialTargetTableSchema.orElseGet(new Supplier<JdbcSchema>(){

            @Override
            public JdbcSchema get() {
                return AbstractJdbcOutputPlugin.this.newJdbcSchemaForNewTable(schema);
            }
        }), task.getColumnOptions());
        if (!mode.isDirectModify()) {
            task.setIntermediateTables(Optional.of(this.createIntermediateTables(con, task, taskCount, newTableSchema)));
        } else {
            task.setIntermediateTables(Optional.empty());
            if (task.getBeforeLoad().isPresent()) {
                con.executeInNewStatement(task.getBeforeLoad().get());
            }
        }
        if (initialTargetTableSchema.isPresent()) {
            targetTableSchema = (JdbcSchema)initialTargetTableSchema.get();
            task.setNewTableSchema(Optional.empty());
        } else if (task.getIntermediateTables().isPresent() && !task.getIntermediateTables().get().isEmpty()) {
            TableIdentifier firstItermTable = task.getIntermediateTables().get().get(0);
            targetTableSchema = this.newJdbcSchemaFromTableIfExists(con, firstItermTable).get();
            task.setNewTableSchema(Optional.of(newTableSchema));
        } else {
            con.createTableIfNotExists(task.getActualTable(), newTableSchema, task.getCreateTableConstraint(), task.getCreateTableOption());
            targetTableSchema = this.newJdbcSchemaFromTableIfExists(con, task.getActualTable()).get();
            task.setNewTableSchema(Optional.empty());
        }
        task.setTargetTableSchema(this.matchSchemaByColumnNames(schema, targetTableSchema));
        AbstractJdbcOutputPlugin.newColumnSetters(this.newColumnSetterFactory(null, task.getDefaultTimeZone()), task.getTargetTableSchema(), schema, task.getColumnOptions());
        if (mode.isMerge()) {
            Optional<List<String>> mergeKeys = task.getMergeKeys();
            if (task.getFeatures().getIgnoreMergeKeys()) {
                if (mergeKeys.isPresent()) {
                    throw new ConfigException("This output type does not accept 'merge_key' option.");
                }
                task.setMergeKeys(Optional.of(Collections.emptyList()));
            } else if (mergeKeys.isPresent()) {
                if (task.getMergeKeys().get().isEmpty()) {
                    throw new ConfigException("Empty 'merge_keys' option is invalid.");
                }
                for (String key : mergeKeys.get()) {
                    if (targetTableSchema.findColumn(key).isPresent()) continue;
                    throw new ConfigException(String.format("Merge key '%s' does not exist in the target table.", key));
                }
            } else {
                ArrayList<String> builder = new ArrayList<String>();
                for (JdbcColumn column : targetTableSchema.getColumns()) {
                    if (!column.isUniqueKey()) continue;
                    builder.add(column.getName());
                }
                task.setMergeKeys(Optional.of(Collections.unmodifiableList(builder)));
                if (task.getMergeKeys().get().isEmpty()) {
                    throw new ConfigException("Merging mode is used but the target table does not have primary keys. Please set merge_keys option.");
                }
            }
            logger.info("Using merge keys: {}", task.getMergeKeys().get());
        } else {
            task.setMergeKeys(Optional.empty());
        }
    }

    protected ColumnSetterFactory newColumnSetterFactory(BatchInsert batch, ZoneId defaultTimeZone) {
        return new ColumnSetterFactory(batch, defaultTimeZone);
    }

    protected TableIdentifier buildIntermediateTableId(JdbcOutputConnection con, PluginTask task, String tableName) {
        return new TableIdentifier(null, con.getSchemaName(), tableName);
    }

    private List<TableIdentifier> createIntermediateTables(final JdbcOutputConnection con, final PluginTask task, final int taskCount, final JdbcSchema newTableSchema) throws SQLException {
        try {
            return (List)AbstractJdbcOutputPlugin.buildRetryExecutor(task).run((Retryable)new Retryable<List<TableIdentifier>>(){
                private TableIdentifier table;
                private ArrayList<TableIdentifier> intermTables;

                public List<TableIdentifier> call() throws Exception {
                    this.intermTables = new ArrayList();
                    if (task.getMode().tempTablePerTask()) {
                        String tableNameFormat = AbstractJdbcOutputPlugin.this.generateIntermediateTableNameFormat(task.getActualTable().getTableName(), con, taskCount, task.getFeatures().getMaxTableNameLength(), task.getFeatures().getTableNameLengthSemantics());
                        for (int taskIndex = 0; taskIndex < taskCount; ++taskIndex) {
                            String tableName = String.format(tableNameFormat, taskIndex);
                            this.table = AbstractJdbcOutputPlugin.this.buildIntermediateTableId(con, task, tableName);
                            con.createTable(this.table, newTableSchema, task.getCreateTableConstraint(), task.getCreateTableOption());
                            this.intermTables.add(this.table);
                        }
                    } else {
                        String tableName = AbstractJdbcOutputPlugin.this.generateIntermediateTableNamePrefix(task.getActualTable().getTableName(), con, 0, task.getFeatures().getMaxTableNameLength(), task.getFeatures().getTableNameLengthSemantics());
                        this.table = AbstractJdbcOutputPlugin.this.buildIntermediateTableId(con, task, tableName);
                        con.createTable(this.table, newTableSchema, task.getCreateTableConstraint(), task.getCreateTableOption());
                        this.intermTables.add(this.table);
                    }
                    return Collections.unmodifiableList(this.intermTables);
                }

                public boolean isRetryableException(Exception exception) {
                    if (exception instanceof SQLException) {
                        try {
                            return con.tableExists(this.table);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    return false;
                }

                public void onRetry(Exception exception, int retryCount, int retryLimit, int retryWait) throws RetryGiveupException {
                    logger.info("Try to create intermediate tables again because already exist");
                    try {
                        this.dropTables();
                    }
                    catch (SQLException e) {
                        throw new RetryGiveupException((Exception)e);
                    }
                }

                public void onGiveup(Exception firstException, Exception lastException) throws RetryGiveupException {
                    try {
                        this.dropTables();
                    }
                    catch (SQLException e) {
                        logger.warn("Cannot delete intermediate table", (Throwable)e);
                    }
                }

                private void dropTables() throws SQLException {
                    for (TableIdentifier table : this.intermTables) {
                        con.dropTableIfExists(table);
                    }
                }
            });
        }
        catch (RetryGiveupException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static int calculateSuffixLength(int taskCount) {
        assert (taskCount >= 0);
        int minimumLength = 3;
        return Math.max(minimumLength, String.valueOf(taskCount - 1).length());
    }

    protected String generateIntermediateTableNameFormat(String baseTableName, JdbcOutputConnection con, int taskCount, int maxLength, LengthSemantics lengthSemantics) throws SQLException {
        int suffixLength = AbstractJdbcOutputPlugin.calculateSuffixLength(taskCount);
        String prefix = this.generateIntermediateTableNamePrefix(baseTableName, con, suffixLength, maxLength, lengthSemantics);
        String suffixFormat = "%0" + suffixLength + "d";
        return prefix + suffixFormat;
    }

    protected String generateIntermediateTableNamePrefix(String baseTableName, JdbcOutputConnection con, int suffixLength, int maxLength, LengthSemantics lengthSemantics) throws SQLException {
        Charset tableNameCharset = con.getTableNameCharset();
        String tableName = baseTableName;
        String suffix = "_embulk";
        String uniqueSuffix = String.format("%016x", System.currentTimeMillis()) + suffix;
        while (!this.checkTableNameLength(tableName + "_" + uniqueSuffix, tableNameCharset, suffixLength, maxLength, lengthSemantics)) {
            if (uniqueSuffix.length() > 8 + suffix.length()) {
                uniqueSuffix = uniqueSuffix.substring(1);
                continue;
            }
            if (tableName.isEmpty()) {
                throw new ConfigException("Table name is too long to generate temporary table name");
            }
            tableName = tableName.substring(0, tableName.length() - 1);
        }
        return tableName + "_" + uniqueSuffix;
    }

    private static JdbcSchema applyColumnOptionsToNewTableSchema(JdbcSchema schema, Map<String, JdbcColumnOption> columnOptions) {
        return new JdbcSchema(schema.getColumns().stream().map(c -> {
            JdbcColumnOption option = AbstractJdbcOutputPlugin.columnOptionOf(columnOptions, c.getName());
            if (option.getType().isPresent()) {
                return JdbcColumn.newTypeDeclaredColumn(c.getName(), 1111, option.getType().get(), false, false);
            }
            return c;
        }).collect(Collectors.toList()));
    }

    protected static List<ColumnSetter> newColumnSetters(ColumnSetterFactory factory, JdbcSchema targetTableSchema, Schema inputValueSchema, Map<String, JdbcColumnOption> columnOptions) {
        ArrayList<ColumnSetter> builder = new ArrayList<ColumnSetter>();
        for (int schemaColumnIndex = 0; schemaColumnIndex < targetTableSchema.getCount(); ++schemaColumnIndex) {
            JdbcColumn targetColumn = targetTableSchema.getColumn(schemaColumnIndex);
            Column inputColumn = inputValueSchema.getColumn(schemaColumnIndex);
            if (targetColumn.isSkipColumn()) {
                builder.add(factory.newSkipColumnSetter());
                continue;
            }
            JdbcColumnOption option = AbstractJdbcOutputPlugin.columnOptionOf(columnOptions, inputColumn.getName());
            builder.add(factory.newColumnSetter(targetColumn, option));
        }
        return Collections.unmodifiableList(builder);
    }

    private static JdbcColumnOption columnOptionOf(Map<String, JdbcColumnOption> columnOptions, String columnName) {
        return Optional.ofNullable(columnOptions.get(columnName)).orElseGet(new Supplier<JdbcColumnOption>(){

            @Override
            public JdbcColumnOption get() {
                return (JdbcColumnOption)CONFIG_MAPPER.map(CONFIG_MAPPER_FACTORY.newConfigSource(), JdbcColumnOption.class);
            }
        });
    }

    private boolean checkTableNameLength(String tableName, Charset tableNameCharset, int suffixLength, int maxLength, LengthSemantics lengthSemantics) {
        return lengthSemantics.countLength(tableNameCharset, tableName) + suffixLength <= maxLength;
    }

    protected void doCommit(JdbcOutputConnection con, PluginTask task, int taskCount) throws SQLException {
        JdbcSchema schema = JdbcSchema.filterSkipColumns(task.getTargetTableSchema());
        switch (task.getMode()) {
            case INSERT_DIRECT: 
            case MERGE_DIRECT: {
                if (!task.getAfterLoad().isPresent()) break;
                con.executeInNewStatement(task.getAfterLoad().get());
                break;
            }
            case INSERT: {
                if (task.getNewTableSchema().isPresent()) {
                    con.createTableIfNotExists(task.getActualTable(), task.getNewTableSchema().get(), task.getCreateTableConstraint(), task.getCreateTableOption());
                }
                con.collectInsert(task.getIntermediateTables().get(), schema, task.getActualTable(), false, task.getBeforeLoad(), task.getAfterLoad());
                break;
            }
            case TRUNCATE_INSERT: {
                if (task.getNewTableSchema().isPresent()) {
                    con.createTableIfNotExists(task.getActualTable(), task.getNewTableSchema().get(), task.getCreateTableConstraint(), task.getCreateTableOption());
                }
                con.collectInsert(task.getIntermediateTables().get(), schema, task.getActualTable(), true, task.getBeforeLoad(), task.getAfterLoad());
                break;
            }
            case MERGE: {
                if (task.getNewTableSchema().isPresent()) {
                    con.createTableIfNotExists(task.getActualTable(), task.getNewTableSchema().get(), task.getCreateTableConstraint(), task.getCreateTableOption());
                }
                con.collectMerge(task.getIntermediateTables().get(), schema, task.getActualTable(), new MergeConfig(task.getMergeKeys().get(), task.getMergeRule()), task.getBeforeLoad(), task.getAfterLoad());
                break;
            }
            case REPLACE: {
                con.replaceTable(task.getIntermediateTables().get().get(0), schema, task.getActualTable(), task.getAfterLoad());
            }
        }
    }

    protected void doCleanup(JdbcOutputConnection con, PluginTask task, int taskCount, List<TaskReport> successTaskReports) throws SQLException {
        if (task.getIntermediateTables().isPresent()) {
            for (TableIdentifier intermTable : task.getIntermediateTables().get()) {
                con.dropTableIfExists(intermTable);
            }
        }
    }

    protected JdbcSchema newJdbcSchemaForNewTable(Schema schema) {
        final ArrayList columns = new ArrayList();
        for (Column c : schema.getColumns()) {
            final String columnName = c.getName();
            c.visit(new ColumnVisitor(){

                public void booleanColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, 16, "BOOLEAN", 1, 0, false, false));
                }

                public void longColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, -5, "BIGINT", 22, 0, false, false));
                }

                public void doubleColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, 6, "DOUBLE PRECISION", 24, 0, false, false));
                }

                public void stringColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, 2005, "CLOB", 4000, 0, false, false));
                }

                public void jsonColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, 2005, "CLOB", 4000, 0, false, false));
                }

                public void timestampColumn(Column column) {
                    columns.add(JdbcColumn.newGenericTypeColumn(columnName, 93, "TIMESTAMP", 26, 0, false, false));
                }
            });
        }
        return new JdbcSchema(Collections.unmodifiableList(columns));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<JdbcSchema> newJdbcSchemaFromTableIfExists(JdbcOutputConnection connection, TableIdentifier table) throws SQLException {
        if (!connection.tableExists(table)) {
            return Optional.empty();
        }
        DatabaseMetaData dbm = connection.getMetaData();
        String escape = dbm.getSearchStringEscape();
        HashSet<String> primaryKeysBuilder = new HashSet<String>();
        try (ResultSet rs = dbm.getPrimaryKeys(table.getDatabase(), table.getSchemaName(), table.getTableName());){
            while (rs.next()) {
                primaryKeysBuilder.add(rs.getString("COLUMN_NAME"));
            }
        }
        Set primaryKeys = Collections.unmodifiableSet(primaryKeysBuilder);
        ArrayList<JdbcColumn> builder = new ArrayList<JdbcColumn>();
        rs = dbm.getColumns(JdbcUtils.escapeSearchString(table.getDatabase(), escape), JdbcUtils.escapeSearchString(table.getSchemaName(), escape), JdbcUtils.escapeSearchString(table.getTableName(), escape), null);
        try {
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String simpleTypeName = rs.getString("TYPE_NAME").toUpperCase(Locale.ENGLISH);
                boolean isUniqueKey = primaryKeys.contains(columnName);
                int sqlType = rs.getInt("DATA_TYPE");
                int colSize = rs.getInt("COLUMN_SIZE");
                int decDigit = rs.getInt("DECIMAL_DIGITS");
                if (rs.wasNull()) {
                    decDigit = -1;
                }
                int charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
                boolean isNotNull = "NO".equals(rs.getString("IS_NULLABLE"));
                builder.add(JdbcColumn.newGenericTypeColumn(columnName, sqlType, simpleTypeName, colSize, decDigit, charOctetLength, isNotNull, isUniqueKey));
            }
        }
        finally {
            rs.close();
        }
        List<JdbcColumn> columns = Collections.unmodifiableList(builder);
        if (columns.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JdbcSchema(columns));
    }

    private JdbcSchema matchSchemaByColumnNames(Schema inputSchema, JdbcSchema targetTableSchema) {
        ArrayList<JdbcColumn> jdbcColumns = new ArrayList<JdbcColumn>();
        for (Column column : inputSchema.getColumns()) {
            Optional<JdbcColumn> c = targetTableSchema.findColumn(column.getName());
            jdbcColumns.add(c.orElse(JdbcColumn.skipColumn()));
        }
        return new JdbcSchema(Collections.unmodifiableList(jdbcColumns));
    }

    public TransactionalPageOutput open(TaskSource taskSource, Schema schema, int taskIndex) {
        PluginTask task = (PluginTask)TASK_MAPPER.map(taskSource, this.getTaskClass());
        Mode mode = task.getMode();
        BatchInsert batch = null;
        try {
            Optional<MergeConfig> config = Optional.empty();
            if (task.getMode() == Mode.MERGE_DIRECT) {
                config = Optional.of(new MergeConfig(task.getMergeKeys().get(), task.getMergeRule()));
            }
            batch = this.newBatchInsert(task, config);
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            PageReader reader = new PageReader(schema);
            List<ColumnSetter> columnSetters = AbstractJdbcOutputPlugin.newColumnSetters(this.newColumnSetterFactory(batch, task.getDefaultTimeZone()), task.getTargetTableSchema(), schema, task.getColumnOptions());
            JdbcSchema insertIntoSchema = JdbcSchema.filterSkipColumns(task.getTargetTableSchema());
            if (insertIntoSchema.getCount() == 0) {
                throw new SQLException("No column to insert.");
            }
            TableIdentifier destTable = mode.tempTablePerTask() ? task.getIntermediateTables().get().get(taskIndex) : (mode.isDirectModify() ? task.getActualTable() : task.getIntermediateTables().get().get(0));
            batch.prepare(destTable, insertIntoSchema);
            PluginPageOutput output = new PluginPageOutput(reader, batch, columnSetters, task.getBatchSize(), task);
            batch = null;
            PluginPageOutput pluginPageOutput = output;
            return pluginPageOutput;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (batch != null) {
                try {
                    batch.close();
                }
                catch (IOException | SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static File findPluginRoot(Class<?> cls) {
        try {
            URL url = cls.getResource("/" + cls.getName().replace('.', '/') + ".class");
            if (url.toString().startsWith("jar:")) {
                url = new URL(url.toString().replaceAll("^jar:", "").replaceAll("![^!]*$", ""));
            }
            File folder = new File(url.toURI()).getParentFile();
            while (true) {
                if (folder == null) {
                    throw new RuntimeException("Cannot find 'embulk-output-xxx' folder.");
                }
                if (folder.getName().startsWith("embulk-output-")) {
                    return folder;
                }
                folder = folder.getParentFile();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isRetryableException(Exception exception) {
        if (exception instanceof SQLException) {
            SQLException ex = (SQLException)exception;
            return this.isRetryableException(ex.getSQLState(), ex.getErrorCode());
        }
        return false;
    }

    protected boolean isRetryableException(String sqlState, int errorCode) {
        return false;
    }

    protected void withRetry(PluginTask task, IdempotentSqlRunnable op) throws SQLException, InterruptedException {
        this.withRetry(task, op, "Operation failed");
    }

    protected void withRetry(PluginTask task, IdempotentSqlRunnable op, String errorMessage) throws SQLException, InterruptedException {
        try {
            AbstractJdbcOutputPlugin.buildRetryExecutor(task).runInterruptible((Retryable)new RetryableSQLExecution(op, errorMessage));
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static RetryExecutor buildRetryExecutor(PluginTask task) {
        return RetryExecutor.retryExecutor().withRetryLimit(task.getRetryLimit()).withInitialRetryWait(task.getRetryWait()).withMaxRetryWait(task.getMaxRetryWait());
    }

    class RetryableSQLExecution
    implements Retryable<Void> {
        private final String errorMessage;
        private final IdempotentSqlRunnable op;
        private final Logger logger = LoggerFactory.getLogger(RetryableSQLExecution.class);

        public RetryableSQLExecution(IdempotentSqlRunnable op, String errorMessage) {
            this.errorMessage = errorMessage;
            this.op = op;
        }

        public Void call() throws Exception {
            this.op.run();
            return null;
        }

        public void onRetry(Exception exception, int retryCount, int retryLimit, int retryWait) {
            if (exception instanceof SQLException) {
                SQLException ex = (SQLException)exception;
                String sqlState = ex.getSQLState();
                int errorCode = ex.getErrorCode();
                this.logger.warn("{} ({}:{}), retrying {}/{} after {} seconds. Message: {}", new Object[]{this.errorMessage, errorCode, sqlState, retryCount, retryLimit, retryWait / 1000, this.buildExceptionMessage(exception)});
            } else {
                this.logger.warn("{}, retrying {}/{} after {} seconds. Message: {}", new Object[]{this.errorMessage, retryCount, retryLimit, retryWait / 1000, this.buildExceptionMessage(exception)});
            }
            if (retryCount % 3 == 0) {
                this.logger.info("Error details:", (Throwable)exception);
            }
        }

        public void onGiveup(Exception firstException, Exception lastException) {
            int errorCode;
            String sqlState;
            SQLException ex;
            if (firstException instanceof SQLException) {
                ex = (SQLException)firstException;
                sqlState = ex.getSQLState();
                errorCode = ex.getErrorCode();
                this.logger.error("{} (first exception:{SQLState={}, ErrorCode={}})", new Object[]{this.errorMessage, errorCode, sqlState, ex});
            } else {
                this.logger.error("{} (first exception)", (Object)this.errorMessage, (Object)firstException);
            }
            if (lastException instanceof SQLException) {
                ex = (SQLException)lastException;
                sqlState = ex.getSQLState();
                errorCode = ex.getErrorCode();
                this.logger.error("{} (last exception:{SQLState={}, ErrorCode={}})", new Object[]{this.errorMessage, errorCode, sqlState, ex});
            } else {
                this.logger.error("{} (last exception)", (Object)this.errorMessage, (Object)lastException);
            }
        }

        public boolean isRetryableException(Exception exception) {
            return AbstractJdbcOutputPlugin.this.isRetryableException(exception);
        }

        private String buildExceptionMessage(Throwable ex) {
            StringBuilder sb = new StringBuilder();
            sb.append(ex.getMessage());
            if (ex.getCause() != null) {
                this.buildExceptionMessageCont(sb, ex.getCause(), ex.getMessage());
            }
            return sb.toString();
        }

        private void buildExceptionMessageCont(StringBuilder sb, Throwable ex, String lastMessage) {
            if (!lastMessage.equals(ex.getMessage())) {
                sb.append(" < ");
                sb.append(ex.getMessage());
            }
            if (ex.getCause() == null) {
                return;
            }
            this.buildExceptionMessageCont(sb, ex.getCause(), ex.getMessage());
        }
    }

    public static interface IdempotentSqlRunnable {
        public void run() throws IOException, SQLException;
    }

    public class PluginPageOutput
    implements TransactionalPageOutput {
        protected final List<Column> columns;
        protected final List<ColumnSetter> columnSetters;
        protected final List<ColumnSetterVisitor> columnVisitors;
        private final PageReaderRecord pageReader;
        private final BatchInsert batch;
        private final int batchSize;
        private final int forceBatchFlushSize;
        private final PluginTask task;

        public PluginPageOutput(PageReader pageReader, BatchInsert batch, List<ColumnSetter> columnSetters, int batchSize, PluginTask task) {
            this.pageReader = new PageReaderRecord(pageReader);
            this.batch = batch;
            this.columns = pageReader.getSchema().getColumns();
            this.columnSetters = columnSetters;
            this.columnVisitors = Collections.unmodifiableList(columnSetters.stream().map(setter -> new ColumnSetterVisitor(this.pageReader, (ColumnSetter)setter)).collect(Collectors.toCollection(ArrayList::new)));
            this.batchSize = batchSize;
            this.task = task;
            this.forceBatchFlushSize = batchSize * 2;
        }

        public void add(Page page) {
            try {
                this.pageReader.setPage(page);
                while (this.pageReader.nextRecord()) {
                    if (this.batch.getBatchWeight() > this.forceBatchFlushSize) {
                        this.flush();
                    }
                    this.handleColumnsSetters();
                    this.batch.add();
                }
                if (this.batch.getBatchWeight() > this.batchSize) {
                    this.flush();
                }
            }
            catch (IOException | InterruptedException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void flush() throws SQLException, InterruptedException {
            AbstractJdbcOutputPlugin.this.withRetry(this.task, new IdempotentSqlRunnable(){
                private boolean first = true;

                @Override
                public void run() throws IOException, SQLException {
                    try {
                        if (!this.first) {
                            PluginPageOutput.this.retryColumnsSetters();
                        }
                        PluginPageOutput.this.batch.flush();
                    }
                    catch (IOException | SQLException ex) {
                        if (!this.first && !AbstractJdbcOutputPlugin.this.isRetryableException(ex)) {
                            logger.error("Retry failed : ", (Throwable)ex);
                        }
                        throw ex;
                    }
                    finally {
                        this.first = false;
                    }
                }
            });
            this.pageReader.clearReadRecords();
        }

        public void finish() {
            try {
                this.flush();
                AbstractJdbcOutputPlugin.this.withRetry(this.task, new IdempotentSqlRunnable(){

                    @Override
                    public void run() throws IOException, SQLException {
                        PluginPageOutput.this.batch.finish();
                    }
                });
            }
            catch (InterruptedException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void close() {
            try {
                this.batch.close();
            }
            catch (IOException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void abort() {
        }

        public TaskReport commit() {
            return CONFIG_MAPPER_FACTORY.newTaskReport();
        }

        protected void handleColumnsSetters() {
            int size = this.columnVisitors.size();
            for (int i = 0; i < size; ++i) {
                this.columns.get(i).visit((ColumnVisitor)this.columnVisitors.get(i));
            }
        }

        protected void retryColumnsSetters() throws IOException, SQLException {
            int size = this.columnVisitors.size();
            int[] updateCounts = this.batch.getLastUpdateCounts();
            int index = 0;
            Iterator<? extends Record> it = this.pageReader.getReadRecords().iterator();
            while (it.hasNext()) {
                Record record = it.next();
                if (index >= updateCounts.length || updateCounts[index] == -3) {
                    for (int i = 0; i < size; ++i) {
                        ColumnSetterVisitor columnVisitor = new ColumnSetterVisitor(record, this.columnSetters.get(i));
                        this.columns.get(i).visit((ColumnVisitor)columnVisitor);
                    }
                    this.batch.add();
                } else {
                    it.remove();
                }
                ++index;
            }
        }
    }

    public static enum Mode {
        INSERT,
        INSERT_DIRECT,
        MERGE,
        MERGE_DIRECT,
        TRUNCATE_INSERT,
        REPLACE;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @JsonCreator
        public static Mode fromString(String value) {
            switch (value) {
                case "insert": {
                    return INSERT;
                }
                case "insert_direct": {
                    return INSERT_DIRECT;
                }
                case "merge": {
                    return MERGE;
                }
                case "merge_direct": {
                    return MERGE_DIRECT;
                }
                case "truncate_insert": {
                    return TRUNCATE_INSERT;
                }
                case "replace": {
                    return REPLACE;
                }
            }
            throw new ConfigException(String.format("Unknown mode '%s'. Supported modes are insert, insert_direct, merge, merge_direct, truncate_insert, replace", value));
        }

        public boolean isDirectModify() {
            return this == INSERT_DIRECT || this == MERGE_DIRECT;
        }

        public boolean isMerge() {
            return this == MERGE || this == MERGE_DIRECT;
        }

        public boolean tempTablePerTask() {
            return this == INSERT || this == MERGE || this == TRUNCATE_INSERT;
        }

        public boolean truncateBeforeCommit() {
            return this == TRUNCATE_INSERT;
        }

        public boolean commitByMerge() {
            return this == MERGE;
        }

        public boolean ignoreTargetTableSchema() {
            return this == REPLACE;
        }

        public boolean commitBySwapTable() {
            return this == REPLACE;
        }
    }

    public static class Features {
        private int maxTableNameLength = 64;
        private LengthSemantics tableNameLengthSemantics = LengthSemantics.BYTES;
        private Set<Mode> supportedModes = Collections.unmodifiableSet(new HashSet<Mode>(Arrays.asList(Mode.values())));
        private boolean ignoreMergeKeys = false;

        @JsonProperty
        public int getMaxTableNameLength() {
            return this.maxTableNameLength;
        }

        @JsonProperty
        public Features setMaxTableNameLength(int bytes) {
            this.maxTableNameLength = bytes;
            return this;
        }

        public LengthSemantics getTableNameLengthSemantics() {
            return this.tableNameLengthSemantics;
        }

        @JsonProperty
        public Features setTableNameLengthSemantics(LengthSemantics tableNameLengthSemantics) {
            this.tableNameLengthSemantics = tableNameLengthSemantics;
            return this;
        }

        @JsonProperty
        public Set<Mode> getSupportedModes() {
            return this.supportedModes;
        }

        @JsonProperty
        public Features setSupportedModes(Set<Mode> modes) {
            this.supportedModes = modes;
            return this;
        }

        @JsonProperty
        public boolean getIgnoreMergeKeys() {
            return this.ignoreMergeKeys;
        }

        @JsonProperty
        public Features setIgnoreMergeKeys(boolean value) {
            this.ignoreMergeKeys = value;
            return this;
        }
    }

    public static enum LengthSemantics {
        BYTES{

            @Override
            public int countLength(Charset charset, String s) {
                return charset.encode(s).remaining();
            }
        }
        ,
        CHARACTERS{

            @Override
            public int countLength(Charset charset, String s) {
                return s.length();
            }
        };


        public abstract int countLength(Charset var1, String var2);
    }

    public static interface PluginTask
    extends Task {
        @Config(value="options")
        @ConfigDefault(value="{}")
        public ToStringMap getOptions();

        @Config(value="table")
        public String getTable();

        @Config(value="mode")
        public Mode getMode();

        @Config(value="batch_size")
        @ConfigDefault(value="16777216")
        public int getBatchSize();

        @Config(value="merge_keys")
        @ConfigDefault(value="null")
        public Optional<List<String>> getMergeKeys();

        @Config(value="column_options")
        @ConfigDefault(value="{}")
        public Map<String, JdbcColumnOption> getColumnOptions();

        @Config(value="create_table_constraint")
        @ConfigDefault(value="null")
        public Optional<String> getCreateTableConstraint();

        @Config(value="create_table_option")
        @ConfigDefault(value="null")
        public Optional<String> getCreateTableOption();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public ZoneId getDefaultTimeZone();

        @Config(value="retry_limit")
        @ConfigDefault(value="12")
        public int getRetryLimit();

        @Config(value="retry_wait")
        @ConfigDefault(value="1000")
        public int getRetryWait();

        @Config(value="max_retry_wait")
        @ConfigDefault(value="1800000")
        public int getMaxRetryWait();

        @Config(value="merge_rule")
        @ConfigDefault(value="null")
        public Optional<List<String>> getMergeRule();

        @Config(value="before_load")
        @ConfigDefault(value="null")
        public Optional<String> getBeforeLoad();

        @Config(value="after_load")
        @ConfigDefault(value="null")
        public Optional<String> getAfterLoad();

        @Config(value="transaction_isolation")
        @ConfigDefault(value="null")
        public Optional<TransactionIsolation> getTransactionIsolation();

        public void setTransactionIsolation(Optional<TransactionIsolation> var1);

        public void setActualTable(TableIdentifier var1);

        public TableIdentifier getActualTable();

        public void setMergeKeys(Optional<List<String>> var1);

        public void setFeatures(Features var1);

        public Features getFeatures();

        public Optional<JdbcSchema> getNewTableSchema();

        public void setNewTableSchema(Optional<JdbcSchema> var1);

        public JdbcSchema getTargetTableSchema();

        public void setTargetTableSchema(JdbcSchema var1);

        public Optional<List<TableIdentifier>> getIntermediateTables();

        public void setIntermediateTables(Optional<List<TableIdentifier>> var1);
    }
}

