/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class JdbcColumn {
    private final String name;
    private final String simpleTypeName;
    private final int sqlType;
    private final int sizeTypeParameter;
    private final int scaleTypeParameter;
    private final int dataLength;
    private final Optional<String> declaredType;
    private final boolean isNotNull;
    private final boolean isUniqueKey;

    @JsonCreator
    public JdbcColumn(@JsonProperty(value="name") String name, @JsonProperty(value="sqlType") int sqlType, @JsonProperty(value="simpleTypeName") String simpleTypeName, @JsonProperty(value="sizeTypeParameter") int sizeTypeParameter, @JsonProperty(value="scaleTypeParameter") int scaleTypeParameter, @JsonProperty(value="dataLength") int dataLength, @JsonProperty(value="declaredType") Optional<String> declaredType, @JsonProperty(value="notNull") boolean isNotNull, @JsonProperty(value="uniqueKey") boolean isUniqueKey) {
        this.name = name;
        this.simpleTypeName = simpleTypeName;
        this.sqlType = sqlType;
        this.sizeTypeParameter = sizeTypeParameter;
        this.scaleTypeParameter = scaleTypeParameter;
        this.dataLength = dataLength;
        this.declaredType = declaredType;
        this.isNotNull = isNotNull;
        this.isUniqueKey = isUniqueKey;
    }

    public static JdbcColumn newGenericTypeColumn(String name, int sqlType, String simpleTypeName, int sizeTypeParameter, int scaleTypeParameter, int dataLength, boolean isNotNull, boolean isUniqueKey) {
        return new JdbcColumn(name, sqlType, simpleTypeName, sizeTypeParameter, scaleTypeParameter, dataLength, Optional.empty(), isNotNull, isUniqueKey);
    }

    public static JdbcColumn newGenericTypeColumn(String name, int sqlType, String simpleTypeName, int sizeTypeParameter, int scaleTypeParameter, boolean isNotNull, boolean isUniqueKey) {
        return new JdbcColumn(name, sqlType, simpleTypeName, sizeTypeParameter, scaleTypeParameter, sizeTypeParameter, Optional.empty(), isNotNull, isUniqueKey);
    }

    public static JdbcColumn newTypeDeclaredColumn(String name, int sqlType, String declaredType, boolean isNotNull, boolean isUniqueKey) {
        return new JdbcColumn(name, sqlType, declaredType, 0, 0, 0, Optional.of(declaredType), isNotNull, isUniqueKey);
    }

    @JsonIgnore
    public static JdbcColumn skipColumn() {
        return new JdbcColumn(null, 0, null, 0, 0, 0, Optional.empty(), false, false);
    }

    @JsonIgnore
    public boolean isSkipColumn() {
        return this.name == null;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="sqlType")
    public int getSqlType() {
        return this.sqlType;
    }

    @JsonProperty(value="simpleTypeName")
    public String getSimpleTypeName() {
        return this.simpleTypeName;
    }

    @JsonProperty(value="sizeTypeParameter")
    public int getSizeTypeParameter() {
        return this.sizeTypeParameter;
    }

    @JsonProperty(value="scaleTypeParameter")
    public int getScaleTypeParameter() {
        return this.scaleTypeParameter;
    }

    @JsonProperty(value="dataLength")
    public int getDataLength() {
        return this.dataLength;
    }

    @JsonProperty(value="declaredType")
    public Optional<String> getDeclaredType() {
        return this.declaredType;
    }

    @JsonProperty(value="notNull")
    public boolean isNotNull() {
        return this.isNotNull;
    }

    @JsonProperty(value="uniqueKey")
    public boolean isUniqueKey() {
        return this.isUniqueKey;
    }
}

