/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.embulk.config.ConfigException;
import org.embulk.output.jdbc.JdbcColumn;

public class JdbcSchema {
    private List<JdbcColumn> columns;

    @JsonCreator
    public JdbcSchema(List<JdbcColumn> columns) {
        this.columns = columns;
    }

    @JsonValue
    public List<JdbcColumn> getColumns() {
        return this.columns;
    }

    public Optional<JdbcColumn> findColumn(String name) {
        for (JdbcColumn column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return Optional.of(column);
        }
        JdbcColumn foundColumn = null;
        for (JdbcColumn column : this.columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            if (foundColumn != null) {
                throw new ConfigException(String.format("Cannot specify column '%s' because both '%s' and '%s' exist.", name, foundColumn.getName(), column.getName()));
            }
            foundColumn = column;
        }
        if (foundColumn != null) {
            return Optional.of(foundColumn);
        }
        return Optional.empty();
    }

    public int getCount() {
        return this.columns.size();
    }

    public JdbcColumn getColumn(int i) {
        return this.columns.get(i);
    }

    public String getColumnName(int i) {
        return this.columns.get(i).getName();
    }

    public static JdbcSchema filterSkipColumns(JdbcSchema schema) {
        ArrayList<JdbcColumn> builder = new ArrayList<JdbcColumn>();
        for (JdbcColumn c : schema.getColumns()) {
            if (c.isSkipColumn()) continue;
            builder.add(c);
        }
        return new JdbcSchema(Collections.unmodifiableList(builder));
    }
}

