/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    public static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    private static String[] SEARCH_STRING_SPECIAL_CHARS = new String[]{"_", "%"};
    private Class<?> connectionClass;

    public static String escapeSearchString(String searchString, String escapeString) {
        if (searchString != null && escapeString != null) {
            searchString = searchString.replaceAll(Pattern.quote(escapeString), Matcher.quoteReplacement(escapeString + escapeString));
            for (String specialChar : SEARCH_STRING_SPECIAL_CHARS) {
                if (specialChar.equals(escapeString)) {
                    throw new IllegalArgumentException("Special char " + specialChar + " cannot be an escape char");
                }
                searchString = searchString.replaceAll(Pattern.quote(specialChar), Matcher.quoteReplacement(escapeString + specialChar));
            }
        }
        return searchString;
    }

    public JdbcUtils(Class<?> connectionClass) {
        this.connectionClass = connectionClass;
    }

    public int executeUpdateWithSqlLogging(Statement stmt, String sql) throws SQLException {
        logger.info("SQL: " + sql);
        long startTime = System.currentTimeMillis();
        int count = stmt.executeUpdate(sql);
        double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (count == 0) {
            logger.info(String.format("> %.2f seconds", seconds));
        } else {
            logger.info(String.format("> %.2f seconds (%,d rows)", seconds, count));
        }
        return count;
    }
}

