/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.embulk.output.jdbc.MemoryRecord;
import org.embulk.output.jdbc.Record;
import org.embulk.spi.Column;
import org.embulk.spi.Page;
import org.embulk.spi.PageReader;
import org.msgpack.value.Value;

public class PageReaderRecord
implements Record {
    private final PageReader pageReader;
    private final List<MemoryRecord> readRecords;
    private MemoryRecord lastRecord;

    public PageReaderRecord(PageReader pageReader) {
        this.pageReader = pageReader;
        this.readRecords = new ArrayList<MemoryRecord>();
    }

    public void setPage(Page page) {
        this.pageReader.setPage(page);
    }

    public boolean nextRecord() {
        this.lastRecord = null;
        return this.pageReader.nextRecord();
    }

    @Override
    public boolean isNull(Column column) {
        return this.pageReader.isNull(column);
    }

    @Override
    public boolean getBoolean(Column column) {
        return this.save(column, this.pageReader.getBoolean(column));
    }

    @Override
    public long getLong(Column column) {
        return this.save(column, this.pageReader.getLong(column));
    }

    @Override
    public double getDouble(Column column) {
        return this.save(column, this.pageReader.getDouble(column));
    }

    @Override
    public String getString(Column column) {
        return this.save(column, this.pageReader.getString(column));
    }

    @Override
    public Instant getTimestamp(Column column) {
        return this.save(column, this.pageReader.getTimestamp(column).getInstant());
    }

    @Override
    public Value getJson(Column column) {
        return this.save(column, this.pageReader.getJson(column));
    }

    public List<? extends Record> getReadRecords() {
        return this.readRecords;
    }

    public void clearReadRecords() {
        this.readRecords.clear();
        this.lastRecord = null;
    }

    private <T> T save(Column column, T value) {
        if (this.lastRecord == null) {
            this.lastRecord = new MemoryRecord(this.pageReader.getSchema().getColumnCount());
            this.readRecords.add(this.lastRecord);
        }
        this.lastRecord.setValue(column, value);
        return value;
    }
}

