/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Optional;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.JdbcOutputConnector;
import org.embulk.output.jdbc.JdbcSchema;
import org.embulk.output.jdbc.MergeConfig;
import org.embulk.output.jdbc.TableIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBatchInsert
implements BatchInsert {
    private static final Logger logger = LoggerFactory.getLogger(StandardBatchInsert.class);
    private final JdbcOutputConnector connector;
    private final Optional<MergeConfig> mergeConfig;
    private JdbcOutputConnection connection;
    private PreparedStatement batch;
    private int index;
    private int batchWeight;
    private int batchRows;
    private long totalRows;
    private int[] lastUpdateCounts;

    public StandardBatchInsert(JdbcOutputConnector connector, Optional<MergeConfig> mergeConfig) throws IOException, SQLException {
        this.connector = connector;
        this.mergeConfig = mergeConfig;
    }

    @Override
    public void prepare(TableIdentifier loadTable, JdbcSchema insertSchema) throws SQLException {
        this.connection = this.connector.connect(true);
        this.index = 1;
        this.batchRows = 0;
        this.totalRows = 0L;
        this.batch = this.prepareStatement(loadTable, insertSchema);
        this.batch.clearBatch();
    }

    protected PreparedStatement prepareStatement(TableIdentifier loadTable, JdbcSchema insertSchema) throws SQLException {
        return this.connection.prepareBatchInsertStatement(loadTable, insertSchema, this.mergeConfig);
    }

    @Override
    public int getBatchWeight() {
        return this.batchWeight;
    }

    @Override
    public void add() throws IOException, SQLException {
        this.batch.addBatch();
        this.index = 1;
        ++this.batchRows;
        this.batchWeight += 32;
    }

    @Override
    public void close() throws IOException, SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public void flush() throws IOException, SQLException {
        this.lastUpdateCounts = new int[0];
        if (this.batchWeight == 0) {
            return;
        }
        logger.info(String.format("Loading %,d rows", this.batchRows));
        long startTime = System.currentTimeMillis();
        try {
            this.lastUpdateCounts = this.batch.executeBatch();
            double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            this.totalRows += (long)this.batchRows;
            logger.info(String.format("> %.2f seconds (loaded %,d rows in total)", seconds, this.totalRows));
        }
        catch (BatchUpdateException e) {
            this.lastUpdateCounts = e.getUpdateCounts();
            throw e;
        }
        finally {
            this.batch.clearBatch();
            this.batchRows = 0;
            this.batchWeight = 0;
        }
    }

    @Override
    public int[] getLastUpdateCounts() {
        return this.lastUpdateCounts;
    }

    @Override
    public void finish() throws IOException, SQLException {
    }

    @Override
    public void setNull(int sqlType) throws IOException, SQLException {
        this.batch.setNull(this.index, sqlType);
        this.nextColumn(0);
    }

    @Override
    public void setBoolean(boolean v) throws IOException, SQLException {
        this.batch.setBoolean(this.index, v);
        this.nextColumn(1);
    }

    @Override
    public void setByte(byte v) throws IOException, SQLException {
        this.batch.setByte(this.index, v);
        this.nextColumn(1);
    }

    @Override
    public void setShort(short v) throws IOException, SQLException {
        this.batch.setShort(this.index, v);
        this.nextColumn(2);
    }

    @Override
    public void setInt(int v) throws IOException, SQLException {
        this.batch.setInt(this.index, v);
        this.nextColumn(4);
    }

    @Override
    public void setLong(long v) throws IOException, SQLException {
        this.batch.setLong(this.index, v);
        this.nextColumn(8);
    }

    @Override
    public void setFloat(float v) throws IOException, SQLException {
        this.batch.setFloat(this.index, v);
        this.nextColumn(4);
    }

    @Override
    public void setDouble(double v) throws IOException, SQLException {
        this.batch.setDouble(this.index, v);
        this.nextColumn(8);
    }

    @Override
    public void setBigDecimal(BigDecimal v) throws IOException, SQLException {
        this.batch.setBigDecimal(this.index, v);
        this.nextColumn((v.precision() & 0xFFFFFFFD) / 2 + 8);
    }

    @Override
    public void setString(String v) throws IOException, SQLException {
        this.batch.setString(this.index, v);
        this.nextColumn(v.length() * 2 + 4);
    }

    @Override
    public void setNString(String v) throws IOException, SQLException {
        this.batch.setNString(this.index, v);
        this.nextColumn(v.length() * 2 + 4);
    }

    @Override
    public void setBytes(byte[] v) throws IOException, SQLException {
        this.batch.setBytes(this.index, v);
        this.nextColumn(v.length + 4);
    }

    @Override
    public void setSqlDate(Instant v, Calendar cal) throws IOException, SQLException {
        cal.setTimeInMillis(v.getEpochSecond() * 1000L);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        Date normalized = new Date(cal.getTimeInMillis());
        this.batch.setDate(this.index, normalized, cal);
        this.nextColumn(32);
    }

    @Override
    public void setSqlTime(Instant v, Calendar cal) throws IOException, SQLException {
        Time t = new Time(v.toEpochMilli());
        this.batch.setTime(this.index, t, cal);
        this.nextColumn(32);
    }

    @Override
    public void setSqlTimestamp(Instant v, Calendar cal) throws IOException, SQLException {
        Timestamp t = new Timestamp(v.toEpochMilli());
        t.setNanos(v.getNano());
        this.batch.setTimestamp(this.index, t, cal);
        this.nextColumn(32);
    }

    private void nextColumn(int weight) {
        ++this.index;
        this.batchWeight += weight + 4;
    }
}

