/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;
import org.embulk.config.ConfigException;

public enum TransactionIsolation {
    READ_UNCOMMITTED{

        @Override
        public int toInt() {
            return 1;
        }
    }
    ,
    READ_COMMITTED{

        @Override
        public int toInt() {
            return 2;
        }
    }
    ,
    REPEATABLE_READ{

        @Override
        public int toInt() {
            return 4;
        }
    }
    ,
    SERIALIZABLE{

        @Override
        public int toInt() {
            return 8;
        }
    };


    @JsonValue
    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public abstract int toInt();

    @JsonCreator
    public static TransactionIsolation fromString(String value) {
        for (TransactionIsolation ti : TransactionIsolation.values()) {
            if (!ti.toString().equals(value)) continue;
            return ti;
        }
        throw new ConfigException(String.format("Unknown transaction_isolation '%s'.", value));
    }

    public static TransactionIsolation fromInt(int value) {
        for (TransactionIsolation ti : TransactionIsolation.values()) {
            if (ti.toInt() != value) continue;
            return ti;
        }
        throw new IllegalArgumentException(String.format("Unknown transaction_isolation '%d'.", value));
    }
}

