/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class BigDecimalColumnSetter
extends ColumnSetter {
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal ONE = BigDecimal.valueOf(1L);

    public BigDecimalColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setBigDecimal();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setBigDecimal(v ? ONE : ZERO);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        this.batch.setBigDecimal(BigDecimal.valueOf(v));
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        if (Double.isNaN(v) || Double.isInfinite(v)) {
            this.defaultValue.setBigDecimal();
        } else {
            this.batch.setBigDecimal(BigDecimal.valueOf(v));
        }
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        BigDecimal dv;
        try {
            dv = new BigDecimal(v);
        }
        catch (NumberFormatException ex) {
            this.defaultValue.setBigDecimal();
            return;
        }
        this.batch.setBigDecimal(dv);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setBigDecimal();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setBigDecimal();
    }
}

