/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class BooleanColumnSetter
extends ColumnSetter {
    public BooleanColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setBoolean();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setBoolean(v);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        this.batch.setBoolean(v > 0L);
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        this.batch.setBoolean(v > 0.0);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        this.defaultValue.setBoolean();
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setBoolean();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setBoolean();
    }
}

