/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class ByteColumnSetter
extends ColumnSetter {
    public ByteColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setByte();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setByte(v ? (byte)1 : 0);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        if (v > 127L || v < -128L) {
            this.defaultValue.setByte();
        } else {
            this.batch.setByte((byte)v);
        }
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        long lv;
        try {
            lv = this.roundDoubleToLong(v);
        }
        catch (ArithmeticException ex) {
            this.defaultValue.setByte();
            return;
        }
        this.longValue(lv);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        byte sv;
        try {
            sv = Byte.parseByte(v);
        }
        catch (NumberFormatException e) {
            this.defaultValue.setByte();
            return;
        }
        this.batch.setByte(sv);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setByte();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setByte();
    }
}

