/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public abstract class ColumnSetter {
    protected final BatchInsert batch;
    protected final JdbcColumn column;
    protected final DefaultValueSetter defaultValue;

    public ColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        this.batch = batch;
        this.column = column;
        this.defaultValue = defaultValue;
    }

    public JdbcColumn getColumn() {
        return this.column;
    }

    public int getSqlType() {
        return this.column.getSqlType();
    }

    public abstract void nullValue() throws IOException, SQLException;

    public abstract void booleanValue(boolean var1) throws IOException, SQLException;

    public abstract void longValue(long var1) throws IOException, SQLException;

    public abstract void doubleValue(double var1) throws IOException, SQLException;

    public abstract void stringValue(String var1) throws IOException, SQLException;

    public abstract void timestampValue(Instant var1) throws IOException, SQLException;

    public abstract void jsonValue(Value var1) throws IOException, SQLException;

    final long roundDoubleToLong(double v) {
        if (Math.getExponent(v) > 1023) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        double z = Math.rint(v);
        double result = Math.abs(v - z) == 0.5 ? v + Math.copySign(0.5, v) : z;
        if (!(-9.223372036854776E18 - result < 1.0) || !(result < 9.223372036854776E18)) {
            throw new ArithmeticException("not in range");
        }
        return (long)result;
    }
}

