/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.embulk.config.ConfigException;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.JdbcColumnOption;
import org.embulk.output.jdbc.setter.BigDecimalColumnSetter;
import org.embulk.output.jdbc.setter.BooleanColumnSetter;
import org.embulk.output.jdbc.setter.ByteColumnSetter;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.embulk.output.jdbc.setter.DoubleColumnSetter;
import org.embulk.output.jdbc.setter.FloatColumnSetter;
import org.embulk.output.jdbc.setter.IntColumnSetter;
import org.embulk.output.jdbc.setter.JsonColumnSetter;
import org.embulk.output.jdbc.setter.LongColumnSetter;
import org.embulk.output.jdbc.setter.NStringColumnSetter;
import org.embulk.output.jdbc.setter.NullColumnSetter;
import org.embulk.output.jdbc.setter.NullDefaultValueSetter;
import org.embulk.output.jdbc.setter.PassThroughColumnSetter;
import org.embulk.output.jdbc.setter.ShortColumnSetter;
import org.embulk.output.jdbc.setter.SkipColumnSetter;
import org.embulk.output.jdbc.setter.SqlDateColumnSetter;
import org.embulk.output.jdbc.setter.SqlTimeColumnSetter;
import org.embulk.output.jdbc.setter.SqlTimestampColumnSetter;
import org.embulk.output.jdbc.setter.StringColumnSetter;
import org.embulk.util.timestamp.TimestampFormatter;

public class ColumnSetterFactory {
    protected final BatchInsert batch;
    protected final ZoneId defaultTimeZone;

    public ColumnSetterFactory(BatchInsert batch, ZoneId defaultTimeZone) {
        this.batch = batch;
        this.defaultTimeZone = defaultTimeZone;
    }

    public SkipColumnSetter newSkipColumnSetter() {
        return new SkipColumnSetter(this.batch);
    }

    public DefaultValueSetter newDefaultValueSetter(JdbcColumn column, JdbcColumnOption option) {
        return new NullDefaultValueSetter(this.batch, column);
    }

    public ColumnSetter newColumnSetter(JdbcColumn column, JdbcColumnOption option) {
        switch (option.getValueType()) {
            case "coerce": {
                return this.newCoalesceColumnSetter(column, option);
            }
            case "byte": {
                return new ByteColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "short": {
                return new ShortColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "int": {
                return new IntColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "long": {
                return new LongColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "double": {
                return new DoubleColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "float": {
                return new FloatColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "boolean": {
                return new BooleanColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "string": {
                return new StringColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newTimestampFormatter(option));
            }
            case "nstring": {
                return new NStringColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newTimestampFormatter(option));
            }
            case "date": {
                return new SqlDateColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case "time": {
                return new SqlTimeColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case "timestamp": {
                return new SqlTimestampColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case "decimal": {
                return new BigDecimalColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "json": {
                return new JsonColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "null": {
                return new NullColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "pass": {
                return new PassThroughColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
        }
        throw new ConfigException(String.format("Unknown value_type '%s' for column '%s'", option.getValueType(), column.getName()));
    }

    protected TimestampFormatter newTimestampFormatter(JdbcColumnOption option) {
        String format = option.getTimestampFormat();
        ZoneId timezone = option.getTimeZone().orElse(this.defaultTimeZone);
        return TimestampFormatter.builder((String)format, (boolean)true).setDefaultZoneId(timezone).build();
    }

    protected Calendar newCalendar(JdbcColumnOption option) {
        return Calendar.getInstance(TimeZone.getTimeZone(this.getTimeZone(option)), Locale.ENGLISH);
    }

    protected ZoneId getTimeZone(JdbcColumnOption option) {
        return option.getTimeZone().orElse(this.defaultTimeZone);
    }

    public ColumnSetter newCoalesceColumnSetter(JdbcColumn column, JdbcColumnOption option) {
        switch (column.getSqlType()) {
            case -6: {
                return new ByteColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 5: {
                return new ShortColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 4: {
                return new IntColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case -5: {
                return new LongColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 6: 
            case 8: {
                return new DoubleColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 7: {
                return new FloatColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case -7: 
            case 16: {
                return new BooleanColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new StringColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newTimestampFormatter(option));
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                return new NStringColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newTimestampFormatter(option));
            }
            case 91: {
                return new SqlDateColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case 92: {
                return new SqlTimeColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case 93: {
                return new SqlTimestampColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case 0: {
                return new NullColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 2: 
            case 3: {
                return new BigDecimalColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
        }
        throw ColumnSetterFactory.unsupportedOperationException(column);
    }

    private static UnsupportedOperationException unsupportedOperationException(JdbcColumn column) {
        throw new UnsupportedOperationException(String.format("Unsupported type %s (sqlType=%d, size=%d, scale=%d)", column.getDeclaredType().orElse(column.getSimpleTypeName()), column.getSqlType(), column.getSizeTypeParameter(), column.getScaleTypeParameter()));
    }
}

