/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import org.embulk.output.jdbc.Record;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;

public class ColumnSetterVisitor
implements ColumnVisitor {
    private final Record record;
    private final ColumnSetter setter;

    public ColumnSetterVisitor(Record record, ColumnSetter setter) {
        this.record = record;
        this.setter = setter;
    }

    public void booleanColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.booleanValue(this.record.getBoolean(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void longColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.longValue(this.record.getLong(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void doubleColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.doubleValue(this.record.getDouble(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stringColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.stringValue(this.record.getString(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void jsonColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.jsonValue(this.record.getJson(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void timestampColumn(Column column) {
        try {
            if (this.record.isNull(column)) {
                this.setter.nullValue();
            } else {
                this.setter.timestampValue(this.record.getTimestamp(column));
            }
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

