/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class IntColumnSetter
extends ColumnSetter {
    public IntColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setInt();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setInt(v ? 1 : 0);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            this.defaultValue.setInt();
        } else {
            this.batch.setInt((int)v);
        }
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        long lv;
        try {
            lv = this.roundDoubleToLong(v);
        }
        catch (ArithmeticException ex) {
            this.defaultValue.setInt();
            return;
        }
        this.longValue(lv);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        int iv;
        try {
            iv = Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            this.defaultValue.setInt();
            return;
        }
        this.batch.setInt(iv);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setInt();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setInt();
    }
}

