/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class LongColumnSetter
extends ColumnSetter {
    public LongColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setLong();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setLong(v ? 1L : 0L);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        this.batch.setLong(v);
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        long lv;
        try {
            lv = this.roundDoubleToLong(v);
        }
        catch (ArithmeticException ex) {
            this.defaultValue.setLong();
            return;
        }
        this.batch.setLong(lv);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        long lv;
        try {
            lv = Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            this.defaultValue.setLong();
            return;
        }
        this.batch.setLong(lv);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setLong();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setLong();
    }
}

