/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Calendar;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class PassThroughColumnSetter
extends ColumnSetter {
    private final Calendar calendar;

    public PassThroughColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue, Calendar calendar) {
        super(batch, column, defaultValue);
        this.calendar = calendar;
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.batch.setNull(this.column.getSqlType());
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setBoolean(v);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        this.batch.setLong(v);
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        this.batch.setDouble(v);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        this.batch.setString(v);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.batch.setSqlTimestamp(v, this.calendar);
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.batch.setString(v.toJson());
    }
}

