/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.jdbc.setter;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.DefaultValueSetter;
import org.msgpack.value.Value;

public class ShortColumnSetter
extends ColumnSetter {
    public ShortColumnSetter(BatchInsert batch, JdbcColumn column, DefaultValueSetter defaultValue) {
        super(batch, column, defaultValue);
    }

    @Override
    public void nullValue() throws IOException, SQLException {
        this.defaultValue.setShort();
    }

    @Override
    public void booleanValue(boolean v) throws IOException, SQLException {
        this.batch.setShort(v ? (short)1 : 0);
    }

    @Override
    public void longValue(long v) throws IOException, SQLException {
        if (v > 32767L || v < -32768L) {
            this.defaultValue.setShort();
        } else {
            this.batch.setShort((short)v);
        }
    }

    @Override
    public void doubleValue(double v) throws IOException, SQLException {
        long lv;
        try {
            lv = this.roundDoubleToLong(v);
        }
        catch (ArithmeticException ex) {
            this.defaultValue.setShort();
            return;
        }
        this.longValue(lv);
    }

    @Override
    public void stringValue(String v) throws IOException, SQLException {
        short sv;
        try {
            sv = Short.parseShort(v);
        }
        catch (NumberFormatException e) {
            this.defaultValue.setShort();
            return;
        }
        this.batch.setShort(sv);
    }

    @Override
    public void timestampValue(Instant v) throws IOException, SQLException {
        this.defaultValue.setShort();
    }

    @Override
    public void jsonValue(Value v) throws IOException, SQLException {
        this.defaultValue.setShort();
    }
}

