/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output;

import java.io.IOException;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.embulk.config.ConfigException;
import org.embulk.output.jdbc.AbstractJdbcOutputPlugin;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.JdbcOutputConnector;
import org.embulk.output.jdbc.MergeConfig;
import org.embulk.output.jdbc.StandardBatchInsert;
import org.embulk.output.jdbc.TableIdentifier;
import org.embulk.output.jdbc.setter.ColumnSetterFactory;
import org.embulk.output.sqlserver.InsertMethod;
import org.embulk.output.sqlserver.NativeBatchInsert;
import org.embulk.output.sqlserver.SQLServerOutputConnector;
import org.embulk.output.sqlserver.setter.SQLServerColumnSetterFactory;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;

public class SQLServerOutputPlugin
extends AbstractJdbcOutputPlugin {
    private static int DEFAULT_PORT = 1433;

    protected Class<? extends AbstractJdbcOutputPlugin.PluginTask> getTaskClass() {
        return SQLServerPluginTask.class;
    }

    protected AbstractJdbcOutputPlugin.Features getFeatures(AbstractJdbcOutputPlugin.PluginTask task) {
        return new AbstractJdbcOutputPlugin.Features().setMaxTableNameLength(128).setSupportedModes(Collections.unmodifiableSet(new HashSet<AbstractJdbcOutputPlugin.Mode>(Arrays.asList(AbstractJdbcOutputPlugin.Mode.INSERT, AbstractJdbcOutputPlugin.Mode.INSERT_DIRECT, AbstractJdbcOutputPlugin.Mode.MERGE, AbstractJdbcOutputPlugin.Mode.TRUNCATE_INSERT, AbstractJdbcOutputPlugin.Mode.REPLACE)))).setIgnoreMergeKeys(false);
    }

    protected JdbcOutputConnector getConnector(AbstractJdbcOutputPlugin.PluginTask task, boolean retryableMetadataOperation) {
        boolean useJtdsDriver;
        SQLServerPluginTask sqlServerTask = (SQLServerPluginTask)task;
        if (sqlServerTask.getDriverPath().isPresent()) {
            this.addDriverJarToClasspath(sqlServerTask.getDriverPath().get());
        }
        if (sqlServerTask.getDriverType().equalsIgnoreCase("mssql-jdbc")) {
            useJtdsDriver = false;
            try {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Can't load Microsoft SQLServerDriver from classpath", (Throwable)e);
            }
        } else if (sqlServerTask.getDriverType().equalsIgnoreCase("jtds")) {
            useJtdsDriver = true;
            try {
                Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Can't load jTDS Driver from classpath", (Throwable)e);
            }
        } else {
            throw new ConfigException("Unknown driver_type : " + sqlServerTask.getDriverType());
        }
        UrlAndProperties urlProps = this.getUrlAndProperties(sqlServerTask, useJtdsDriver);
        this.logConnectionProperties(urlProps.getUrl(), urlProps.getProps());
        return new SQLServerOutputConnector(urlProps.getUrl(), urlProps.getProps(), sqlServerTask.getSchema().orElse(null), sqlServerTask.getTransactionIsolation());
    }

    private UrlAndProperties getUrlAndProperties(SQLServerPluginTask sqlServerTask, boolean useJtdsDriver) {
        String url;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)sqlServerTask.getOptions());
        if (sqlServerTask.getUser().isPresent()) {
            props.setProperty("user", sqlServerTask.getUser().get());
        }
        if (sqlServerTask.getPassword().isPresent()) {
            props.setProperty("password", sqlServerTask.getPassword().get());
        }
        if (sqlServerTask.getUrl().isPresent()) {
            if (sqlServerTask.getInsertMethod() == InsertMethod.NATIVE) {
                throw new IllegalArgumentException("Cannot set 'url' when 'insert_method' is 'native'.");
            }
            if (sqlServerTask.getHost().isPresent() || sqlServerTask.getInstance().isPresent() || sqlServerTask.getDatabase().isPresent()) {
                throw new IllegalArgumentException("'host', 'instance' and 'database' parameters are invalid if 'url' parameter is set.");
            }
            url = sqlServerTask.getUrl().get();
        } else {
            if (!sqlServerTask.getHost().isPresent()) {
                throw new IllegalArgumentException("Field 'host' is not set.");
            }
            if (!sqlServerTask.getDatabase().isPresent()) {
                throw new IllegalArgumentException("Field 'database' is not set.");
            }
        }
        if (useJtdsDriver) {
            if (sqlServerTask.getInstance().isPresent()) {
                if (sqlServerTask.getPort() != DEFAULT_PORT) {
                    logger.warn("'port: {}' option is ignored because instance option is set", (Object)sqlServerTask.getPort());
                }
                url = String.format(Locale.ENGLISH, "jdbc:jtds:sqlserver://%s", sqlServerTask.getHost().get());
                props.setProperty("instance", sqlServerTask.getInstance().get());
            } else {
                url = String.format(Locale.ENGLISH, "jdbc:jtds:sqlserver://%s:%d", sqlServerTask.getHost().get(), sqlServerTask.getPort());
            }
            if (sqlServerTask.getDatabase().isPresent()) {
                url = url + "/" + sqlServerTask.getDatabase().get();
            }
            if (sqlServerTask.getIntegratedSecurity().isPresent()) {
                throw new ConfigException("'integratedSecutiry' option is not supported with jTDS driver. Set 'driver_path: /path/to/sqljdbc.jar' option if you want to use Microsoft SQLServerDriver.");
            }
            if (!sqlServerTask.getUser().isPresent()) {
                throw new ConfigException("'user' option is required but not set.");
            }
            if (sqlServerTask.getSocketTimeout().isPresent()) {
                props.setProperty("socketTimeout", String.valueOf(sqlServerTask.getSocketTimeout().get()));
            }
        } else {
            StringBuilder urlBuilder = new StringBuilder();
            if (sqlServerTask.getInstance().isPresent()) {
                urlBuilder.append(String.format("jdbc:sqlserver://%s\\%s", sqlServerTask.getHost().get(), sqlServerTask.getInstance().get()));
            } else {
                urlBuilder.append(String.format("jdbc:sqlserver://%s:%d", sqlServerTask.getHost().get(), sqlServerTask.getPort()));
            }
            if (sqlServerTask.getDatabase().isPresent()) {
                urlBuilder.append(";databaseName=" + sqlServerTask.getDatabase().get());
            }
            if (sqlServerTask.getIntegratedSecurity().isPresent() && sqlServerTask.getIntegratedSecurity().get().booleanValue()) {
                urlBuilder.append(";integratedSecurity=" + sqlServerTask.getIntegratedSecurity().get());
            } else {
                if (!sqlServerTask.getUser().isPresent()) {
                    throw new IllegalArgumentException("Field 'user' is not set.");
                }
                if (!sqlServerTask.getPassword().isPresent()) {
                    throw new IllegalArgumentException("Field 'password' is not set.");
                }
            }
            if (sqlServerTask.getSocketTimeout().isPresent()) {
                props.setProperty("socketTimeout", String.valueOf((long)sqlServerTask.getSocketTimeout().get().intValue() * 1000L));
            }
            url = urlBuilder.toString();
        }
        if (sqlServerTask.getConnectTimeout().isPresent()) {
            props.setProperty("loginTimeout", String.valueOf(sqlServerTask.getConnectTimeout().get()));
        }
        return new UrlAndProperties(url, props);
    }

    protected TableIdentifier buildIntermediateTableId(JdbcOutputConnection con, AbstractJdbcOutputPlugin.PluginTask task, String tableName) {
        SQLServerPluginTask sqlServerTask = (SQLServerPluginTask)task;
        if (sqlServerTask.getTempSchema().isPresent() && sqlServerTask.getMode() != AbstractJdbcOutputPlugin.Mode.REPLACE) {
            return new TableIdentifier(null, sqlServerTask.getTempSchema().get(), tableName);
        }
        return super.buildIntermediateTableId(con, task, tableName);
    }

    protected BatchInsert newBatchInsert(AbstractJdbcOutputPlugin.PluginTask task, Optional<MergeConfig> mergeConfig) throws IOException, SQLException {
        SQLServerPluginTask sqlServerTask = (SQLServerPluginTask)task;
        if (sqlServerTask.getInsertMethod() == InsertMethod.NATIVE) {
            return new NativeBatchInsert(sqlServerTask.getHost().get(), sqlServerTask.getPort(), sqlServerTask.getInstance(), sqlServerTask.getDatabase().get(), sqlServerTask.getUser(), sqlServerTask.getPassword(), sqlServerTask.getNativeDriverName(), sqlServerTask.getDatabaseEncoding());
        }
        return new StandardBatchInsert(this.getConnector(task, true), mergeConfig);
    }

    protected ColumnSetterFactory newColumnSetterFactory(BatchInsert batch, ZoneId defaultTimeZone) {
        return new SQLServerColumnSetterFactory(batch, defaultTimeZone);
    }

    private static class UrlAndProperties {
        private final String url;
        private final Properties props;

        public UrlAndProperties(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getProps() {
            return this.props;
        }
    }

    public static interface SQLServerPluginTask
    extends AbstractJdbcOutputPlugin.PluginTask {
        @Config(value="driver_path")
        @ConfigDefault(value="null")
        public Optional<String> getDriverPath();

        @Config(value="driver_type")
        @ConfigDefault(value="\"mssql-jdbc\"")
        public String getDriverType();

        @Config(value="host")
        @ConfigDefault(value="null")
        public Optional<String> getHost();

        @Config(value="port")
        @ConfigDefault(value="1433")
        public int getPort();

        @Config(value="instance")
        @ConfigDefault(value="null")
        public Optional<String> getInstance();

        @Config(value="database")
        @ConfigDefault(value="null")
        public Optional<String> getDatabase();

        @Config(value="integratedSecurity")
        @ConfigDefault(value="null")
        public Optional<Boolean> getIntegratedSecurity();

        @Config(value="url")
        @ConfigDefault(value="null")
        public Optional<String> getUrl();

        @Config(value="user")
        @ConfigDefault(value="null")
        public Optional<String> getUser();

        @Config(value="password")
        @ConfigDefault(value="\"\"")
        public Optional<String> getPassword();

        @Config(value="schema")
        @ConfigDefault(value="null")
        public Optional<String> getSchema();

        @Config(value="temp_schema")
        @ConfigDefault(value="null")
        public Optional<String> getTempSchema();

        @Config(value="insert_method")
        @ConfigDefault(value="\"normal\"")
        public InsertMethod getInsertMethod();

        @Config(value="native_driver")
        @ConfigDefault(value="null")
        public Optional<String> getNativeDriverName();

        @Config(value="database_encoding")
        @ConfigDefault(value="\"MS932\"")
        public String getDatabaseEncoding();

        @Config(value="connect_timeout")
        @ConfigDefault(value="null")
        public Optional<Integer> getConnectTimeout();

        @Config(value="socket_timeout")
        @ConfigDefault(value="null")
        public Optional<Integer> getSocketTimeout();
    }
}

