/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.sqlserver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Optional;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.JdbcSchema;
import org.embulk.output.jdbc.StandardBatchInsert;
import org.embulk.output.jdbc.TableIdentifier;
import org.embulk.output.jdbc.TimestampFormat;
import org.embulk.output.sqlserver.SmallDateTimeFormat;
import org.embulk.output.sqlserver.nativeclient.NativeClientWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeBatchInsert
implements BatchInsert {
    private static final Logger logger = LoggerFactory.getLogger(StandardBatchInsert.class);
    private NativeClientWrapper client = new NativeClientWrapper();
    private final String server;
    private final int port;
    private final Optional<String> instance;
    private final String database;
    private final Optional<String> user;
    private final Optional<String> password;
    private final Optional<String> nativeDriverName;
    private final String databaseEncoding;
    private int batchWeight;
    private int batchRows;
    private long totalRows;
    private int columnCount;
    private int lastColumnIndex;
    private DateFormat[] formats;

    public NativeBatchInsert(String server, int port, Optional<String> instance, String database, Optional<String> user, Optional<String> password, Optional<String> nativeDriverName, String databaseEncoding) {
        this.server = server;
        this.port = port;
        this.instance = instance;
        this.database = database;
        this.user = user;
        this.password = password;
        this.nativeDriverName = nativeDriverName;
        this.databaseEncoding = databaseEncoding;
        this.lastColumnIndex = 0;
    }

    public void prepare(TableIdentifier loadTable, JdbcSchema insertSchema) throws SQLException {
        this.columnCount = insertSchema.getCount();
        this.client.open(this.server, this.port, this.instance, this.database, this.user, this.password, loadTable.getSchemaName(), loadTable.getTableName(), this.nativeDriverName, this.databaseEncoding);
        this.formats = new DateFormat[insertSchema.getCount()];
        block5: for (int i = 0; i < insertSchema.getCount(); ++i) {
            JdbcColumn column = insertSchema.getColumn(i);
            switch (column.getSqlType()) {
                case 91: {
                    this.formats[i] = new SimpleDateFormat("yyyy-MM-dd");
                    continue block5;
                }
                case 92: {
                    this.formats[i] = new TimestampFormat("HH:mm:ss", column.getScaleTypeParameter());
                    continue block5;
                }
                case 93: {
                    if (column.getSimpleTypeName().equals("SMALLDATETIME")) {
                        this.formats[i] = new SmallDateTimeFormat("yyyy-MM-dd HH:mm:ss");
                        continue block5;
                    }
                    this.formats[i] = new TimestampFormat("yyyy-MM-dd HH:mm:ss", column.getScaleTypeParameter());
                    continue block5;
                }
            }
        }
    }

    public int getBatchWeight() {
        return this.batchWeight;
    }

    public void add() throws IOException, SQLException {
        this.client.sendRow();
        ++this.batchRows;
        this.batchWeight += 32;
    }

    private int nextColumnIndex() {
        int nextColumnIndex = this.lastColumnIndex + 1;
        this.lastColumnIndex = nextColumnIndex == this.columnCount ? 0 : ++this.lastColumnIndex;
        return nextColumnIndex;
    }

    public void setNull(int sqlType) throws IOException, SQLException {
        this.batchWeight += this.client.bindNull(this.nextColumnIndex(), sqlType);
    }

    public void setBoolean(boolean v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setByte(byte v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setShort(short v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setInt(int v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setLong(long v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setFloat(float v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setDouble(double v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setBigDecimal(BigDecimal v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v.toPlainString());
    }

    public void setString(String v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setNString(String v) throws IOException, SQLException {
        this.batchWeight += this.client.bindValue(this.nextColumnIndex(), v);
    }

    public void setBytes(byte[] v) throws IOException, SQLException {
        throw new SQLException("Unsupported");
    }

    public void setSqlDate(Instant v, Calendar cal) throws IOException, SQLException {
        this.setSqlTimestamp(v, cal);
    }

    public void setSqlTime(Instant v, Calendar cal) throws IOException, SQLException {
        this.setSqlTimestamp(v, cal);
    }

    public void setSqlTimestamp(Instant v, Calendar cal) throws IOException, SQLException {
        int columnIndex = this.nextColumnIndex();
        DateFormat format = this.formats[columnIndex - 1];
        format.setCalendar(cal);
        Timestamp timestamp = new Timestamp(v.toEpochMilli());
        timestamp.setNanos(v.getNano());
        this.batchWeight += this.client.bindValue(columnIndex, format.format(timestamp));
    }

    public void flush() throws IOException, SQLException {
        if (this.batchWeight == 0) {
            return;
        }
        logger.info(String.format("Loading %,d rows", this.batchRows));
        long startTime = System.currentTimeMillis();
        this.client.commit(false);
        double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.totalRows += (long)this.batchRows;
        logger.info(String.format("> %.2f seconds (loaded %,d rows in total)", seconds, this.totalRows));
        this.batchRows = 0;
        this.batchWeight = 0;
    }

    public int[] getLastUpdateCounts() {
        return new int[0];
    }

    public void finish() throws IOException, SQLException {
        this.client.commit(true);
    }

    public void close() throws IOException, SQLException {
        this.client.close();
    }
}

