/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.JdbcSchema;
import org.embulk.output.jdbc.MergeConfig;
import org.embulk.output.jdbc.TableIdentifier;

public class SQLServerOutputConnection
extends JdbcOutputConnection {
    private static final String[] SIMPLE_TYPE_NAMES = new String[]{"BIT", "FLOAT"};

    public SQLServerOutputConnection(Connection connection, String schemaName) throws SQLException {
        super(connection, schemaName);
    }

    protected String buildRenameTableSql(TableIdentifier fromTable, TableIdentifier toTable) {
        StringBuilder sb = new StringBuilder();
        sb.append("EXEC sp_rename ");
        if (fromTable.getSchemaName() == null) {
            sb.append(this.quoteIdentifierString(fromTable.getTableName()));
        } else {
            sb.append(this.quoteIdentifierString(fromTable.getSchemaName() + "." + fromTable.getTableName()));
        }
        sb.append(", ");
        sb.append(this.quoteIdentifierString(toTable.getTableName()));
        sb.append(", 'OBJECT'");
        return sb.toString();
    }

    protected String buildColumnTypeName(JdbcColumn c) {
        switch (c.getSimpleTypeName()) {
            case "BOOLEAN": {
                return "BIT";
            }
            case "CLOB": {
                return "NVARCHAR(max)";
            }
            case "TIMESTAMP": {
                return "DATETIME2";
            }
            case "NVARCHAR": {
                if (c.getSizeTypeParameter() > 4000) {
                    return "NVARCHAR(max)";
                }
            }
            case "VARCHAR": {
                if (c.getSizeTypeParameter() <= 8000) break;
                return "VARCHAR(max)";
            }
        }
        return super.buildColumnTypeName(c);
    }

    protected void setSearchPath(String schema) throws SQLException {
    }

    protected boolean supportsTableIfExistsClause() {
        return false;
    }

    protected JdbcOutputConnection.ColumnDeclareType getColumnDeclareType(String convertedTypeName, JdbcColumn col) {
        if (Arrays.asList(SIMPLE_TYPE_NAMES).contains(convertedTypeName)) {
            return JdbcOutputConnection.ColumnDeclareType.SIMPLE;
        }
        return super.getColumnDeclareType(convertedTypeName, col);
    }

    protected String buildCollectMergeSql(List<TableIdentifier> fromTables, JdbcSchema schema, TableIdentifier toTable, MergeConfig mergeConfig) throws SQLException {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO ");
        sb.append(this.quoteTableIdentifier(toTable));
        sb.append(" AS T");
        sb.append(" USING (");
        for (i = 0; i < fromTables.size(); ++i) {
            if (i != 0) {
                sb.append(" UNION ALL ");
            }
            sb.append(" SELECT ");
            sb.append(this.buildColumns(schema, ""));
            sb.append(" FROM ");
            sb.append(this.quoteTableIdentifier(fromTables.get(i)));
        }
        sb.append(") AS S");
        sb.append(" ON (");
        for (i = 0; i < mergeConfig.getMergeKeys().size(); ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            String mergeKey = this.quoteIdentifierString((String)mergeConfig.getMergeKeys().get(i));
            sb.append("T.");
            sb.append(mergeKey);
            sb.append(" = S.");
            sb.append(mergeKey);
        }
        sb.append(")");
        sb.append(" WHEN MATCHED THEN");
        sb.append(" UPDATE SET ");
        if (mergeConfig.getMergeRule().isPresent()) {
            for (i = 0; i < ((List)mergeConfig.getMergeRule().get()).size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append((String)((List)mergeConfig.getMergeRule().get()).get(i));
            }
        } else {
            for (i = 0; i < schema.getCount(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                String column = this.quoteIdentifierString(schema.getColumnName(i));
                sb.append(column);
                sb.append(" = S.");
                sb.append(column);
            }
        }
        sb.append(" WHEN NOT MATCHED THEN");
        sb.append(" INSERT (");
        sb.append(this.buildColumns(schema, ""));
        sb.append(") VALUES (");
        sb.append(this.buildColumns(schema, "S."));
        sb.append(");");
        return sb.toString();
    }

    private String buildColumns(JdbcSchema schema, String prefix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < schema.getCount(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(prefix);
            sb.append(this.quoteIdentifierString(schema.getColumnName(i)));
        }
        return sb.toString();
    }
}

