/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.sqlserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import org.embulk.output.jdbc.AbstractJdbcOutputConnector;
import org.embulk.output.jdbc.JdbcOutputConnection;
import org.embulk.output.jdbc.TransactionIsolation;
import org.embulk.output.sqlserver.SQLServerOutputConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerOutputConnector
extends AbstractJdbcOutputConnector {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerOutputConnector.class);
    private final String url;
    private final Properties properties;
    private final String schemaName;

    public SQLServerOutputConnector(String url, Properties properties, String schemaName, Optional<TransactionIsolation> transactionIsolation) {
        super(transactionIsolation);
        this.url = url;
        this.properties = properties;
        this.schemaName = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcOutputConnection connect() throws SQLException {
        Object object;
        Connection c = DriverManager.getConnection(this.url, this.properties);
        if (c == null) {
            throw new SQLException("Invalid url : " + this.url);
        }
        String schemaName = this.schemaName;
        if (schemaName == null) {
            try {
                PreparedStatement statement = c.prepareStatement("SELECT default_schema_name FROM sys.database_principals WHERE name = ?");
                object = null;
                try {
                    statement.setString(1, this.properties.getProperty("user"));
                    try (ResultSet rs = statement.executeQuery();){
                        if (rs.next()) {
                            schemaName = rs.getString(1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (object != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                logger.warn("Cannot specify default schema : " + e);
            }
        }
        try {
            SQLServerOutputConnection con = new SQLServerOutputConnection(c, schemaName);
            c = null;
            object = con;
            return object;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }
}

