/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.sqlserver.nativeclient;

import com.kenai.jffi.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.ArrayMemoryIO;
import org.embulk.output.sqlserver.nativeclient.NativeClient;
import org.embulk.output.sqlserver.nativeclient.ODBC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeClientWrapper {
    private static int MAX_COLUMN_SIZE_FOR_BCP_BIND = 7999;
    private static ODBC odbc;
    private static NativeClient client;
    private static final Logger logger;
    private Charset charset;
    private Charset wideCharset;
    private Pointer envHandle;
    private Pointer odbcHandle;
    private Map<Integer, Pointer> boundPointers = new HashMap<Integer, Pointer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeClientWrapper() {
        String nativeClientLibName;
        String odbcLibName;
        Platform platform = Platform.getPlatform();
        Platform.OS os = platform.getOS();
        if (os == Platform.OS.WINDOWS) {
            odbcLibName = "odbc32";
            nativeClientLibName = "sqlncli11";
        } else {
            odbcLibName = "odbc";
            nativeClientLibName = "msodbcsql";
        }
        Class<NativeClientWrapper> clazz = NativeClientWrapper.class;
        synchronized (NativeClientWrapper.class) {
            if (odbc == null) {
                logger.info(String.format("Loading SQL Server Native Client library (%s).", odbcLibName));
                try {
                    odbc = (ODBC)LibraryLoader.create(ODBC.class).failImmediately().load(odbcLibName);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new RuntimeException(platform.mapLibraryName(odbcLibName) + " not found.", e);
                }
            }
            if (client == null) {
                logger.info(String.format("Loading SQL Server Native Client library (%s).", nativeClientLibName));
                try {
                    client = (NativeClient)LibraryLoader.create(NativeClient.class).failImmediately().load(nativeClientLibName);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new RuntimeException(platform.mapLibraryName(nativeClientLibName) + " not found.", e);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void open(String server, int port, Optional<String> instance, String database, Optional<String> user, Optional<String> password, String schemaName, String table, Optional<String> nativeDriverName, String databaseEncoding) throws SQLException {
        this.charset = Charset.forName(databaseEncoding);
        this.wideCharset = Charset.forName("UTF-16LE");
        Pointer envHandlePointer = this.createPointerPointer();
        this.checkSQLResult("SQLAllocHandle(SQL_HANDLE_ENV)", odbc.SQLAllocHandle((short)1, null, envHandlePointer));
        this.envHandle = envHandlePointer.getPointer(0L);
        this.checkSQLResult("SQLSetEnvAttr(SQL_ATTR_ODBC_VERSION)", odbc.SQLSetEnvAttr(this.envHandle, (short)200, Pointer.wrap((Runtime)Runtime.getSystemRuntime(), (long)3L), -6));
        Pointer odbcHandlePointer = this.createPointerPointer();
        this.checkSQLResult("SQLAllocHandle(SQL_HANDLE_DBC)", odbc.SQLAllocHandle((short)2, this.envHandle, odbcHandlePointer));
        this.odbcHandle = odbcHandlePointer.getPointer(0L);
        this.checkSQLResult("SQLSetConnectAttr(SQL_COPT_SS_BCP)", odbc.SQLSetConnectAttrW(this.odbcHandle, 1219, Pointer.wrap((Runtime)Runtime.getSystemRuntime(), (long)1L), -6));
        StringBuilder connectionString = new StringBuilder();
        if (nativeDriverName.isPresent()) {
            connectionString.append(String.format("Driver=%s;", nativeDriverName.get()));
        } else {
            connectionString.append("Driver={SQL Server Native Client 11.0};");
        }
        if (instance.isPresent()) {
            connectionString.append(String.format("Server=%s,%d\\%s;", server, port, instance.get()));
        } else {
            connectionString.append(String.format("Server=%s,%d;", server, port));
        }
        connectionString.append(String.format("Database=%s;", database));
        if (user.isPresent()) {
            connectionString.append(String.format("UID=%s;", user.get()));
        }
        if (password.isPresent()) {
            logger.info("connection string = " + connectionString + "PWD=********;");
            connectionString.append(String.format("PWD=%s;", password.get()));
        } else {
            logger.info("connection string = " + connectionString);
        }
        this.checkSQLResult("SQLDriverConnect", odbc.SQLDriverConnectW(this.odbcHandle, null, this.toWideChars(connectionString.toString()), (short)-3, null, (short)-3, null, (short)0));
        StringBuilder fullTableName = new StringBuilder();
        fullTableName.append("[");
        fullTableName.append(database);
        fullTableName.append("].[");
        fullTableName.append(schemaName);
        fullTableName.append("].[");
        fullTableName.append(table);
        fullTableName.append("]");
        this.checkBCPResult("bcp_init", client.bcp_initW(this.odbcHandle, this.toWideChars(fullTableName.toString()), null, null, 1));
    }

    public int bindNull(int columnIndex, int sqlType) throws SQLException {
        Pointer pointer = this.prepareBuffer(columnIndex, 0);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, -1, null, 0, this.jdbcTypeToNativeClientType(sqlType), columnIndex));
        return (int)pointer.size();
    }

    private int jdbcTypeToNativeClientType(int sqlType) {
        switch (sqlType) {
            case -7: 
            case 16: {
                return 50;
            }
            case -6: 
            case 5: {
                return 52;
            }
            case 4: {
                return 56;
            }
            case -5: {
                return 127;
            }
            case 7: {
                return 59;
            }
            case 6: 
            case 8: {
                return 62;
            }
        }
        return 47;
    }

    public int bindValue(int columnIndex, String value) throws SQLException {
        ByteBuffer bytes = this.charset.encode(value);
        int size = bytes.remaining();
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.put(0L, bytes.array(), 0, size);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, Math.min(size, MAX_COLUMN_SIZE_FOR_BCP_BIND), null, 0, 47, columnIndex));
        if (size > MAX_COLUMN_SIZE_FOR_BCP_BIND) {
            this.checkBCPResult("bcp_collen", client.bcp_collen(this.odbcHandle, size, columnIndex));
        }
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, boolean value) throws SQLException {
        int size = 1;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putByte(0L, value ? (byte)1 : 0);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 50, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, byte value) throws SQLException {
        int size = 1;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putByte(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 48, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, short value) throws SQLException {
        int size = 2;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putShort(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 52, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, int value) throws SQLException {
        int size = 4;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putInt(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 56, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, long value) throws SQLException {
        int size = 8;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putLongLong(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 127, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, float value) throws SQLException {
        int size = 4;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putFloat(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 59, columnIndex));
        return (int)pointer.size();
    }

    public int bindValue(int columnIndex, double value) throws SQLException {
        int size = 8;
        Pointer pointer = this.prepareBuffer(columnIndex, size);
        pointer.putDouble(0L, value);
        this.checkBCPResult("bcp_bind", client.bcp_bind(this.odbcHandle, pointer, 0, size, null, 0, 62, columnIndex));
        return (int)pointer.size();
    }

    private Pointer prepareBuffer(int columnIndex, int size) {
        Pointer pointer = this.boundPointers.get(columnIndex);
        if (pointer == null || pointer.size() < (long)size) {
            Runtime runtime = Runtime.getSystemRuntime();
            pointer = Pointer.wrap((Runtime)runtime, (ByteBuffer)ByteBuffer.allocateDirect(size).order(runtime.byteOrder()));
            this.boundPointers.put(columnIndex, pointer);
        }
        return pointer;
    }

    public void sendRow() throws SQLException {
        this.checkBCPResult("bcp_sendrow", client.bcp_sendrow(this.odbcHandle));
    }

    public void commit(boolean done) throws SQLException {
        int result;
        String operation;
        if (done) {
            operation = "bcp_done";
            result = client.bcp_done(this.odbcHandle);
        } else {
            operation = "bcp_batch";
            result = client.bcp_batch(this.odbcHandle);
        }
        if (result < 0) {
            this.throwException(operation, (short)0);
        } else if (result > 0) {
            logger.info(String.format("SQL Server Native Client : %,d rows have been loaded.", result));
        }
    }

    public void close() {
        if (this.odbcHandle != null) {
            odbc.SQLFreeHandle((short)2, this.odbcHandle);
            this.odbcHandle = null;
        }
        if (this.envHandle != null) {
            odbc.SQLFreeHandle((short)1, this.envHandle);
            this.envHandle = null;
        }
    }

    private Pointer createPointerPointer() {
        return new ArrayMemoryIO(Runtime.getSystemRuntime(), Type.POINTER.size());
    }

    private String toString(Pointer wcharPointer, int length) {
        byte[] bytes = new byte[length * 2];
        wcharPointer.get(0L, bytes, 0, length * 2);
        CharBuffer chars = this.wideCharset.decode(ByteBuffer.wrap(bytes));
        return chars.toString();
    }

    private Pointer toWideChars(String s) {
        ByteBuffer bytes = this.wideCharset.encode(s);
        ArrayMemoryIO pointer = new ArrayMemoryIO(Runtime.getSystemRuntime(), bytes.remaining() + 2);
        pointer.put(0L, bytes.array(), 0, bytes.remaining());
        pointer.putShort((long)bytes.remaining(), (short)0);
        return pointer;
    }

    private void checkSQLResult(String operation, short result) throws SQLException {
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                StringBuilder sqlState = new StringBuilder();
                StringBuilder sqlMessage = new StringBuilder();
                if (!this.getErrorMessage(sqlState, sqlMessage)) break;
                logger.info(String.format("SQL Server Native Client : %s : %s", operation, sqlMessage));
                break;
            }
            default: {
                this.throwException(operation, result);
            }
        }
    }

    private void checkBCPResult(String operation, short result) throws SQLException {
        switch (result) {
            case 1: {
                break;
            }
            default: {
                this.throwException(operation, result);
            }
        }
    }

    private void throwException(String operation, short result) throws SQLException {
        StringBuilder sqlMessage;
        StringBuilder sqlState;
        String message = String.format("SQL Server Native Client : %s failed : %d.", operation, result);
        if (this.odbcHandle != null && this.getErrorMessage(sqlState = new StringBuilder(), sqlMessage = new StringBuilder())) {
            message = String.format("SQL Server Native Client : %s failed (sql state = %s) : %s", operation, sqlState, sqlMessage);
        }
        logger.error(message);
        throw new SQLException(message);
    }

    private boolean getErrorMessage(StringBuilder sqlState, StringBuilder sqlMessage) {
        int sqlStateLength = 5;
        ArrayMemoryIO sqlStatePointer = new ArrayMemoryIO(Runtime.getSystemRuntime(), 12);
        ArrayMemoryIO sqlMessagePointer = new ArrayMemoryIO(Runtime.getSystemRuntime(), 512);
        ArrayMemoryIO lengthPointer = new ArrayMemoryIO(Runtime.getSystemRuntime(), 4);
        short record = 1;
        while (true) {
            short result;
            if ((result = odbc.SQLGetDiagRecW((short)2, this.odbcHandle, record, (Pointer)sqlStatePointer, null, (Pointer)sqlMessagePointer, (short)(sqlMessagePointer.size() / 2L), (Pointer)lengthPointer)) == 0) {
                if (record > 1) {
                    sqlState.append(",");
                }
            } else {
                return record != 1;
            }
            sqlState.append(this.toString((Pointer)sqlStatePointer, 5));
            sqlMessage.append(this.toString((Pointer)sqlMessagePointer, lengthPointer.getInt(0L)));
            record = (short)(record + 1);
        }
    }

    static {
        logger = LoggerFactory.getLogger(NativeClientWrapper.class);
    }
}

