/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.sqlserver.setter;

import java.time.ZoneId;
import org.embulk.output.jdbc.BatchInsert;
import org.embulk.output.jdbc.JdbcColumn;
import org.embulk.output.jdbc.JdbcColumnOption;
import org.embulk.output.jdbc.setter.ColumnSetter;
import org.embulk.output.jdbc.setter.ColumnSetterFactory;
import org.embulk.output.jdbc.setter.StringColumnSetter;
import org.embulk.output.sqlserver.setter.SQLServerByteColumnSetter;
import org.embulk.output.sqlserver.setter.SQLServerSqlTimeColumnSetter;

public class SQLServerColumnSetterFactory
extends ColumnSetterFactory {
    public SQLServerColumnSetterFactory(BatchInsert batch, ZoneId defaultTimeZone) {
        super(batch, defaultTimeZone);
    }

    public ColumnSetter newCoalesceColumnSetter(JdbcColumn column, JdbcColumnOption option) {
        switch (column.getSqlType()) {
            case -6: {
                return new SQLServerByteColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case 92: {
                return new SQLServerSqlTimeColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
        }
        return super.newCoalesceColumnSetter(column, option);
    }

    public ColumnSetter newColumnSetter(JdbcColumn column, JdbcColumnOption option) {
        switch (option.getValueType()) {
            case "byte": {
                return new SQLServerByteColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option));
            }
            case "time": {
                return new SQLServerSqlTimeColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newCalendar(option));
            }
            case "coerce": {
                switch (column.getSimpleTypeName().toLowerCase()) {
                    case "date": 
                    case "datetime2": 
                    case "time": 
                    case "sql_variant": 
                    case "datetimeoffset": {
                        return new StringColumnSetter(this.batch, column, this.newDefaultValueSetter(column, option), this.newTimestampFormatter(option));
                    }
                }
                return super.newColumnSetter(column, option);
            }
        }
        return super.newColumnSetter(column, option);
    }
}

