/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.stdout;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.type.TimestampType;
import org.embulk.util.timestamp.TimestampFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagePrinter {
    private final Schema schema;
    private final TimestampFormatter[] timestampFormatters;
    private final ArrayList<String> record;
    private static final Logger logger = LoggerFactory.getLogger(PagePrinter.class);

    public PagePrinter(Schema schema, String timeZoneId) {
        int i;
        this.schema = schema;
        this.timestampFormatters = new TimestampFormatter[schema.getColumnCount()];
        for (i = 0; i < this.timestampFormatters.length; ++i) {
            if (!(schema.getColumnType(i) instanceof TimestampType)) continue;
            TimestampType type = (TimestampType)schema.getColumnType(i);
            this.timestampFormatters[i] = TimestampFormatter.builder((String)this.getFormatFromTimestampTypeWithDeprecationSuppressed(type), (boolean)true).setDefaultZoneFromString(timeZoneId).build();
        }
        this.record = new ArrayList(schema.getColumnCount());
        for (i = 0; i < schema.getColumnCount(); ++i) {
            this.record.add("");
        }
    }

    public String printRecord(PageReader reader, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Column c : this.schema.getColumns()) {
            if (c.getIndex() != 0) {
                sb.append(delimiter);
            }
            sb.append(this.printColumn(reader, c));
        }
        return sb.toString();
    }

    public List<String> printRecord(PageReader reader) {
        for (Column c : this.schema.getColumns()) {
            this.record.set(c.getIndex(), this.printColumn(reader, c));
        }
        return this.record;
    }

    public String printColumn(PageReader reader, Column column) {
        if (reader.isNull(column)) {
            return "";
        }
        ToStringColumnVisitor visitor = new ToStringColumnVisitor(reader);
        column.visit((ColumnVisitor)visitor);
        return visitor.string;
    }

    private String getFormatFromTimestampTypeWithDeprecationSuppressed(TimestampType timestampType) {
        return timestampType.getFormat();
    }

    private static Instant getTimestamp(PageReader reader, Column column) {
        try {
            return reader.getTimestampInstant(column);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-output-stdout is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            return reader.getTimestamp(column).getInstant();
        }
    }

    private class ToStringColumnVisitor
    implements ColumnVisitor {
        private final PageReader reader;
        String string = "";

        public ToStringColumnVisitor(PageReader reader) {
            this.reader = reader;
        }

        public void booleanColumn(Column column) {
            this.string = Boolean.toString(this.reader.getBoolean(column));
        }

        public void longColumn(Column column) {
            this.string = Long.toString(this.reader.getLong(column));
        }

        public void doubleColumn(Column column) {
            this.string = Double.toString(this.reader.getDouble(column));
        }

        public void stringColumn(Column column) {
            this.string = this.reader.getString(column);
        }

        public void timestampColumn(Column column) {
            this.string = PagePrinter.this.timestampFormatters[column.getIndex()].format(PagePrinter.getTimestamp(this.reader, column));
        }

        public void jsonColumn(Column column) {
            this.string = this.reader.getJson(column).toString();
        }
    }
}

