/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.output.stdout;

import java.util.List;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.output.stdout.PagePrinter;
import org.embulk.spi.Column;
import org.embulk.spi.Exec;
import org.embulk.spi.OutputPlugin;
import org.embulk.spi.Page;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.TransactionalPageOutput;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdoutOutputPlugin
implements OutputPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Logger logger = LoggerFactory.getLogger(StdoutOutputPlugin.class);

    public ConfigDiff transaction(ConfigSource config, Schema schema, int taskCount, OutputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        if (task.getPrintsColumnNames()) {
            for (Column column : schema.getColumns()) {
                if (column.getIndex() > 0) {
                    System.out.print(",");
                }
                System.out.print(column.getName());
            }
            System.out.println("");
        }
        return this.resume(task.dump(), schema, taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, OutputPlugin.Control control) {
        control.run(taskSource);
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    public void cleanup(TaskSource taskSource, Schema schema, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TransactionalPageOutput open(TaskSource taskSource, final Schema schema, int taskIndex) {
        final PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        return new TransactionalPageOutput(){
            private final PageReader reader;
            private final PagePrinter printer;
            {
                this.reader = StdoutOutputPlugin.getPageReader(schema);
                this.printer = new PagePrinter(schema, task.getTimeZoneId());
            }

            public void add(Page page) {
                this.reader.setPage(page);
                while (this.reader.nextRecord()) {
                    System.out.println(this.printer.printRecord(this.reader, ","));
                }
            }

            public void finish() {
                System.out.flush();
            }

            public void close() {
                this.reader.close();
            }

            public void abort() {
            }

            public TaskReport commit() {
                return CONFIG_MAPPER_FACTORY.newTaskReport();
            }
        };
    }

    private static PageReader getPageReader(Schema schema) {
        try {
            return Exec.getPageReader((Schema)schema);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-output-stdout is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            return new PageReader(schema);
        }
    }

    public static interface PluginTask
    extends Task {
        @Config(value="prints_column_names")
        @ConfigDefault(value="false")
        public boolean getPrintsColumnNames();

        @Config(value="timezone")
        @ConfigDefault(value="\"UTC\"")
        public String getTimeZoneId();
    }
}

