/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.parser.csv;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.embulk.config.ConfigException;
import org.embulk.parser.csv.CsvParserPlugin;
import org.embulk.spi.DataException;
import org.embulk.util.text.LineDecoder;

public class CsvTokenizer {
    private static final char END_OF_LINE = '\u0000';
    static final char NO_QUOTE = '\u0000';
    static final char NO_ESCAPE = '\u0000';
    private final char delimiterChar;
    private final String delimiterFollowingString;
    private final char quote;
    private final char escape;
    private final String newline;
    private final boolean trimIfNotQuoted;
    private final CsvParserPlugin.QuotesInQuotedFields quotesInQuotedFields;
    private final long maxQuotedSizeLimit;
    private final String commentLineMarker;
    private final LineDecoder input;
    private final String nullStringOrNull;
    private RecordState recordState = RecordState.END;
    private long lineNumber = 0L;
    private String line = null;
    private int linePos = 0;
    private boolean wasQuotedColumn = false;
    private List<String> quotedValueLines = new ArrayList<String>();
    private Deque<String> unreadLines = new ArrayDeque<String>();

    public CsvTokenizer(LineDecoder input, CsvParserPlugin.PluginTask task) {
        String delimiter = task.getDelimiter();
        if (delimiter.length() == 0) {
            throw new ConfigException("Empty delimiter is not allowed");
        }
        this.delimiterChar = delimiter.charAt(0);
        this.delimiterFollowingString = delimiter.length() > 1 ? delimiter.substring(1) : null;
        this.quote = task.getQuoteChar().orElse(CsvParserPlugin.QuoteCharacter.noQuote()).getCharacter();
        this.escape = task.getEscapeChar().orElse(CsvParserPlugin.EscapeCharacter.noEscape()).getCharacter();
        this.newline = task.getNewline().getString();
        this.trimIfNotQuoted = task.getTrimIfNotQuoted();
        this.quotesInQuotedFields = task.getQuotesInQuotedFields();
        if (this.trimIfNotQuoted && this.quotesInQuotedFields != CsvParserPlugin.QuotesInQuotedFields.ACCEPT_ONLY_RFC4180_ESCAPED) {
            throw new ConfigException("[quotes_in_quoted_fields != ACCEPT_ONLY_RFC4180_ESCAPED] is not allowed to specify with [trim_if_not_quoted = true]");
        }
        this.maxQuotedSizeLimit = task.getMaxQuotedSizeLimit();
        this.commentLineMarker = task.getCommentLineMarker().orElse(null);
        this.nullStringOrNull = task.getNullString().orElse(null);
        this.input = input;
    }

    public long getCurrentLineNumber() {
        return this.lineNumber;
    }

    public boolean skipHeaderLine() {
        boolean skipped;
        boolean bl = skipped = this.input.poll() != null;
        if (skipped) {
            ++this.lineNumber;
        }
        return skipped;
    }

    public String skipCurrentLine() {
        String skippedLine;
        if (this.quotedValueLines.isEmpty()) {
            skippedLine = this.line;
        } else {
            skippedLine = this.quotedValueLines.remove(0);
            this.unreadLines.addAll(this.quotedValueLines);
            this.lineNumber -= (long)this.quotedValueLines.size();
            if (this.line != null) {
                this.unreadLines.add(this.line);
                --this.lineNumber;
            }
            this.quotedValueLines.clear();
        }
        this.recordState = RecordState.END;
        return skippedLine;
    }

    public boolean nextFile() {
        boolean next = this.input.nextFile();
        if (next) {
            this.lineNumber = 0L;
        }
        return next;
    }

    public boolean nextRecord() {
        return this.nextRecord(true);
    }

    public boolean nextRecord(boolean skipEmptyLine) {
        if (this.recordState != RecordState.END) {
            throw new TooManyColumnsException("Too many columns");
        }
        boolean hasNext = this.nextLine(skipEmptyLine);
        if (hasNext) {
            this.recordState = RecordState.NOT_END;
            return true;
        }
        return false;
    }

    private boolean nextLine(boolean skipEmptyLine) {
        boolean skip;
        do {
            if (!this.unreadLines.isEmpty()) {
                this.line = this.unreadLines.removeFirst();
            } else {
                this.line = this.input.poll();
                if (this.line == null) {
                    return false;
                }
            }
            this.linePos = 0;
            ++this.lineNumber;
        } while (skip = skipEmptyLine && (this.line.isEmpty() || this.commentLineMarker != null && this.line.startsWith(this.commentLineMarker)));
        return true;
    }

    public boolean hasNextColumn() {
        return this.recordState == RecordState.NOT_END;
    }

    public String nextColumn() {
        if (!this.hasNextColumn()) {
            throw new TooFewColumnsException("Too few columns");
        }
        this.wasQuotedColumn = false;
        this.quotedValueLines.clear();
        int valueStartPos = this.linePos;
        int valueEndPos = 0;
        StringBuilder quotedValue = null;
        ColumnState columnState = ColumnState.BEGIN;
        block8: while (true) {
            char c = this.nextChar();
            switch (columnState) {
                case BEGIN: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return "";
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return "";
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return "";
                    }
                    if (this.isSpace(c) && this.trimIfNotQuoted) {
                        columnState = ColumnState.FIRST_TRIM;
                        break;
                    }
                    if (this.isQuote(c)) {
                        valueStartPos = this.linePos;
                        this.wasQuotedColumn = true;
                        quotedValue = new StringBuilder();
                        columnState = ColumnState.QUOTED_VALUE;
                        break;
                    }
                    columnState = ColumnState.VALUE;
                    break;
                }
                case FIRST_TRIM: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return "";
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return "";
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return "";
                    }
                    if (this.isQuote(c)) {
                        valueStartPos = this.linePos;
                        this.wasQuotedColumn = true;
                        quotedValue = new StringBuilder();
                        columnState = ColumnState.QUOTED_VALUE;
                        break;
                    }
                    if (this.isSpace(c)) continue block8;
                    valueStartPos = this.linePos - 1;
                    columnState = ColumnState.VALUE;
                    break;
                }
                case VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return this.line.substring(valueStartPos, this.linePos - 1);
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            String value = this.line.substring(valueStartPos, this.linePos - 1);
                            this.linePos += this.delimiterFollowingString.length();
                            return value;
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return this.line.substring(valueStartPos, this.linePos);
                    }
                    if (!this.isSpace(c) || !this.trimIfNotQuoted) continue block8;
                    valueEndPos = this.linePos - 1;
                    columnState = ColumnState.LAST_TRIM_OR_VALUE;
                    break;
                }
                case LAST_TRIM_OR_VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return this.line.substring(valueStartPos, valueEndPos);
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return this.line.substring(valueStartPos, valueEndPos);
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return this.line.substring(valueStartPos, valueEndPos);
                    }
                    if (this.isSpace(c)) continue block8;
                    columnState = ColumnState.VALUE;
                    break;
                }
                case QUOTED_VALUE: {
                    char next;
                    if (this.isEndOfLine(c)) {
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                        quotedValue.append(this.newline);
                        this.quotedValueLines.add(this.line);
                        if (!this.nextLine(false)) {
                            throw new InvalidValueException("Unexpected end of line during parsing a quoted value");
                        }
                        valueStartPos = 0;
                        break;
                    }
                    if (this.isQuote(c)) {
                        next = this.peekNextChar();
                        char nextNext = this.peekNextNextChar();
                        if (this.isQuote(next) && (this.quotesInQuotedFields != CsvParserPlugin.QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS || !this.isDelimiter(nextNext) && !this.isEndOfLine(nextNext))) {
                            quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                            valueStartPos = ++this.linePos;
                            break;
                        }
                        if (this.quotesInQuotedFields == CsvParserPlugin.QuotesInQuotedFields.ACCEPT_STRAY_QUOTES_ASSUMING_NO_DELIMITERS_IN_FIELDS && !this.isDelimiter(next) && !this.isEndOfLine(next)) {
                            if ((long)(this.linePos - valueStartPos + quotedValue.length()) <= this.maxQuotedSizeLimit) continue block8;
                            throw new QuotedSizeLimitExceededException("The size of the quoted value exceeds the limit size (" + this.maxQuotedSizeLimit + ")");
                        }
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos - 1));
                        columnState = ColumnState.AFTER_QUOTED_VALUE;
                        break;
                    }
                    if (this.isEscape(c)) {
                        next = this.peekNextChar();
                        if (this.isEndOfLine(c)) {
                            quotedValue.append(this.line.substring(valueStartPos, this.linePos));
                            this.quotedValueLines.add(this.line);
                            if (!this.nextLine(false)) {
                                throw new InvalidValueException("Unexpected end of line during parsing a quoted value");
                            }
                            valueStartPos = 0;
                            break;
                        }
                        if (!this.isQuote(next) && !this.isEscape(next)) continue block8;
                        quotedValue.append(this.line.substring(valueStartPos, this.linePos - 1));
                        quotedValue.append(next);
                        valueStartPos = ++this.linePos;
                        break;
                    }
                    if ((long)(this.linePos - valueStartPos + quotedValue.length()) <= this.maxQuotedSizeLimit) continue block8;
                    throw new QuotedSizeLimitExceededException("The size of the quoted value exceeds the limit size (" + this.maxQuotedSizeLimit + ")");
                }
                case AFTER_QUOTED_VALUE: {
                    if (this.isDelimiter(c)) {
                        if (this.delimiterFollowingString == null) {
                            return quotedValue.toString();
                        }
                        if (this.isDelimiterFollowingFrom(this.linePos)) {
                            this.linePos += this.delimiterFollowingString.length();
                            return quotedValue.toString();
                        }
                    }
                    if (this.isEndOfLine(c)) {
                        this.recordState = RecordState.END;
                        return quotedValue.toString();
                    }
                    if (this.isSpace(c)) continue block8;
                    throw new InvalidValueException(String.format("Unexpected extra character '%c' after a value quoted by '%c'", Character.valueOf(c), Character.valueOf(this.quote)));
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
    }

    public String nextColumnOrNull() {
        String v = this.nextColumn();
        if (this.nullStringOrNull == null) {
            if (v.isEmpty()) {
                if (this.wasQuotedColumn) {
                    return "";
                }
                return null;
            }
            return v;
        }
        if (v.equals(this.nullStringOrNull)) {
            return null;
        }
        return v;
    }

    public boolean wasQuotedColumn() {
        return this.wasQuotedColumn;
    }

    private char nextChar() {
        if (this.line == null) {
            throw new IllegalStateException("nextColumn is called after end of file");
        }
        if (this.linePos >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos++);
    }

    private char peekNextChar() {
        if (this.line == null) {
            throw new IllegalStateException("peekNextChar is called after end of file");
        }
        if (this.linePos >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos);
    }

    private char peekNextNextChar() {
        if (this.line == null) {
            throw new IllegalStateException("peekNextNextChar is called after end of file");
        }
        if (this.linePos + 1 >= this.line.length()) {
            return '\u0000';
        }
        return this.line.charAt(this.linePos + 1);
    }

    private boolean isSpace(char c) {
        return c == ' ';
    }

    private boolean isDelimiterFollowingFrom(int pos) {
        if (this.line.length() < pos + this.delimiterFollowingString.length()) {
            return false;
        }
        for (int i = 0; i < this.delimiterFollowingString.length(); ++i) {
            if (this.delimiterFollowingString.charAt(i) == this.line.charAt(pos + i)) continue;
            return false;
        }
        return true;
    }

    private boolean isDelimiter(char c) {
        return c == this.delimiterChar;
    }

    private boolean isEndOfLine(char c) {
        return c == '\u0000';
    }

    private boolean isQuote(char c) {
        return this.quote != '\u0000' && c == this.quote;
    }

    private boolean isEscape(char c) {
        return this.escape != '\u0000' && c == this.escape;
    }

    public class TooFewColumnsException
    extends InvalidFormatException {
        public TooFewColumnsException(String message) {
            super(message);
        }
    }

    public class TooManyColumnsException
    extends InvalidFormatException {
        public TooManyColumnsException(String message) {
            super(message);
        }
    }

    public static class QuotedSizeLimitExceededException
    extends InvalidValueException {
        public QuotedSizeLimitExceededException(String message) {
            super(message);
        }
    }

    public static class InvalidValueException
    extends DataException {
        public InvalidValueException(String message) {
            super(message);
        }
    }

    public static class InvalidFormatException
    extends DataException {
        public InvalidFormatException(String message) {
            super(message);
        }
    }

    static enum ColumnState {
        BEGIN,
        VALUE,
        QUOTED_VALUE,
        AFTER_QUOTED_VALUE,
        FIRST_TRIM,
        LAST_TRIM_OR_VALUE;

    }

    static enum RecordState {
        NOT_END,
        END;

    }
}

