/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.parser.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.DataException;
import org.embulk.spi.Exec;
import org.embulk.spi.FileInput;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.ParserPlugin;
import org.embulk.spi.Schema;
import org.embulk.spi.json.JsonArray;
import org.embulk.spi.json.JsonObject;
import org.embulk.spi.json.JsonValue;
import org.embulk.spi.type.TimestampType;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.config.units.ColumnConfig;
import org.embulk.util.config.units.SchemaConfig;
import org.embulk.util.file.FileInputInputStream;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonValueParser;
import org.embulk.util.timestamp.TimestampFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParserPlugin
implements ParserPlugin {
    private static final Logger logger = LoggerFactory.getLogger(JsonParserPlugin.class);
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Pattern DIGITS_PATTERN = Pattern.compile("\\p{XDigit}+");
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public void transaction(ConfigSource configSource, ParserPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(configSource, PluginTask.class);
        control.run(task.dump(), this.newSchema(task));
    }

    Schema newSchema(PluginTask task) {
        if (JsonParserPlugin.isUsingCustomSchema(task)) {
            return task.getSchemaConfig().get().toSchema();
        }
        return Schema.builder().add("record", (Type)Types.JSON).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(TaskSource taskSource, Schema schema, FileInput input, PageOutput output) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        boolean stopOnInvalidRecord = task.getStopOnInvalidRecord();
        HashMap<Column, TimestampFormatter> timestampFormatters = new HashMap<Column, TimestampFormatter>();
        HashMap<Column, String> jsonPointers = new HashMap<Column, String>();
        if (JsonParserPlugin.isUsingCustomSchema(task)) {
            SchemaConfig schemaConfig = task.getSchemaConfig().get();
            timestampFormatters.putAll(JsonParserPlugin.newTimestampColumnFormattersAsMap(task, task.getSchemaConfig().get()));
            jsonPointers.putAll(JsonParserPlugin.createJsonPointerMap(schema, schemaConfig));
        }
        JsonValueParser.Builder parserBuilder = JsonValueParser.builder((JsonFactory)JSON_FACTORY);
        try (PageBuilder pageBuilder = Exec.getPageBuilder((BufferAllocator)Exec.getBufferAllocator(), (Schema)schema, (PageOutput)output);
             FileInputInputStream in = new FileInputInputStream(input);){
            while (in.nextFile()) {
                String fileName = input.hintOfCurrentInputFileNameForLogging().orElse("-");
                boolean evenOneJsonParsed = false;
                try {
                    JsonValueParser parser = this.newParser(in, task, parserBuilder);
                    Throwable throwable = null;
                    try {
                        JsonValue originalValue;
                        while ((originalValue = parser.readJsonValue()) != null) {
                            try {
                                JsonArray recordValues;
                                JsonValue value = originalValue;
                                if (task.getRoot().isPresent()) {
                                    try {
                                        value = JsonValueParser.builder((JsonFactory)JSON_FACTORY).root(task.getRoot().get()).build(originalValue.toJson()).readJsonValue();
                                        if (value == null) {
                                            throw new JsonRecordValidateException("A Json record doesn't have given 'JSON pointer to root'.");
                                        }
                                    }
                                    catch (JsonParseException e) {
                                        throw new JsonRecordValidateException("A Json record doesn't have given 'JSON pointer to root'.");
                                    }
                                }
                                if (task.getFlattenJsonArray()) {
                                    if (!value.isJsonArray()) {
                                        throw new JsonRecordValidateException(String.format("A Json record must represent array value with 'flatten_json_array' option, but it's %s", value.getEntityType().name()));
                                    }
                                    recordValues = value.asJsonArray();
                                } else {
                                    recordValues = Collections.singletonList(value);
                                }
                                for (JsonValue recordValue : recordValues) {
                                    this.addRecord(task, pageBuilder, schema, timestampFormatters, jsonPointers, recordValue);
                                    evenOneJsonParsed = true;
                                }
                            }
                            catch (JsonRecordValidateException e) {
                                if (stopOnInvalidRecord) {
                                    throw new DataException(String.format("Invalid record in %s: %s", fileName, originalValue.toJson()), (Throwable)((Object)e));
                                }
                                logger.warn(String.format("Skipped record in %s (%s): %s", fileName, e.getMessage(), originalValue.toJson()));
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (parser == null) continue;
                        if (throwable != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        parser.close();
                    }
                }
                catch (IOException | JsonParseException e) {
                    if (Exec.isPreview() && evenOneJsonParsed) break;
                    throw new DataException(String.format("Failed to parse JSON: %s", fileName), e);
                }
            }
            pageBuilder.finish();
            return;
        }
    }

    private void addRecord(PluginTask task, PageBuilder pageBuilder, Schema schema, Map<Column, TimestampFormatter> timestampFormatters, Map<Column, String> jsonPointers, JsonValue value) {
        if (!value.isJsonObject()) {
            throw new JsonRecordValidateException(String.format("A Json record must represent map value but it's %s", value.getEntityType().name()));
        }
        try {
            if (JsonParserPlugin.isUsingCustomSchema(task)) {
                this.setValueWithCustomSchema(pageBuilder, schema, timestampFormatters, jsonPointers, value.asJsonObject());
            } else {
                JsonParserPlugin.setValueWithSingleJsonColumn(pageBuilder, schema, value.asJsonObject());
            }
        }
        catch (DateTimeParseException ex) {
            throw new JsonRecordValidateException(String.format("A Json record must have valid timestamp value but it's %s", value.getEntityType().name()));
        }
        pageBuilder.addRecord();
    }

    private static boolean isUsingCustomSchema(PluginTask task) {
        return task.getSchemaConfig().isPresent() && !task.getSchemaConfig().get().isEmpty();
    }

    private static void setValueWithSingleJsonColumn(PageBuilder pageBuilder, Schema schema, JsonObject value) {
        Column column = schema.getColumn(0);
        pageBuilder.setJson(column, (JsonValue)value);
    }

    private void setValueWithCustomSchema(final PageBuilder pageBuilder, Schema schema, final Map<Column, TimestampFormatter> timestampFormatters, Map<Column, String> jsonPointers, JsonObject value) {
        JsonObject map = value;
        String valueAsJsonString = null;
        if (!jsonPointers.isEmpty()) {
            valueAsJsonString = value.toJson();
        }
        for (Column column : schema.getColumns()) {
            JsonValue columnValue;
            String jsonPointer = jsonPointers.get(column);
            if (jsonPointer != null) {
                try {
                    columnValue = JsonValueParser.builder((JsonFactory)JSON_FACTORY).root(jsonPointer).build(valueAsJsonString).readJsonValue();
                }
                catch (IOException ex) {
                    throw new JsonParseException("Failed to parse JSON: " + valueAsJsonString, (Throwable)ex);
                }
            } else {
                columnValue = (JsonValue)map.get(column.getName());
            }
            if (columnValue == null || columnValue.isJsonNull()) {
                pageBuilder.setNull(column);
                continue;
            }
            column.visit(new ColumnVisitor(){

                public void booleanColumn(Column column) {
                    boolean booleanValue = columnValue.isJsonBoolean() ? columnValue.asJsonBoolean().booleanValue() : Boolean.parseBoolean(JsonParserPlugin.asString(columnValue));
                    pageBuilder.setBoolean(column, booleanValue);
                }

                public void longColumn(Column column) {
                    long longValue = columnValue.isJsonLong() ? columnValue.asJsonLong().longValue() : Long.parseLong(JsonParserPlugin.asString(columnValue));
                    pageBuilder.setLong(column, longValue);
                }

                public void doubleColumn(Column column) {
                    double doubleValue = columnValue.isJsonDouble() ? columnValue.asJsonDouble().doubleValue() : Double.parseDouble(JsonParserPlugin.asString(columnValue));
                    pageBuilder.setDouble(column, doubleValue);
                }

                public void stringColumn(Column column) {
                    pageBuilder.setString(column, JsonParserPlugin.asString(columnValue));
                }

                public void timestampColumn(Column column) {
                    pageBuilder.setTimestamp(column, ((TimestampFormatter)timestampFormatters.get(column)).parse(JsonParserPlugin.asString(columnValue)));
                }

                public void jsonColumn(Column column) {
                    pageBuilder.setJson(column, columnValue);
                }
            });
        }
    }

    private JsonValueParser newParser(FileInputInputStream in, PluginTask task, JsonValueParser.Builder builder) throws IOException {
        InvalidEscapeStringPolicy policy = task.getInvalidEscapeStringPolicy();
        switch (policy) {
            case SKIP: 
            case UNESCAPE: {
                byte[] lines = new BufferedReader(new InputStreamReader((InputStream)in)).lines().map(JsonParserPlugin.invalidEscapeStringFunction(policy)).collect(Collectors.joining()).getBytes(StandardCharsets.UTF_8);
                return builder.build((InputStream)new ByteArrayInputStream(lines));
            }
        }
        return builder.build((InputStream)in);
    }

    static Function<String, String> invalidEscapeStringFunction(InvalidEscapeStringPolicy policy) {
        return input -> {
            Objects.requireNonNull(input);
            if (policy == InvalidEscapeStringPolicy.PASSTHROUGH) {
                return input;
            }
            StringBuilder builder = new StringBuilder();
            char[] charArray = input.toCharArray();
            block8: for (int characterIndex = 0; characterIndex < charArray.length; ++characterIndex) {
                char c = charArray[characterIndex];
                if (c == '\\') {
                    if (charArray.length <= characterIndex + 1) continue;
                    char next = charArray[characterIndex + 1];
                    block0 : switch (next) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            builder.append(c);
                            break;
                        }
                        case 'u': {
                            if (charArray.length <= characterIndex + 5) continue block8;
                            char[] hexChars = new char[]{charArray[characterIndex + 2], charArray[characterIndex + 3], charArray[characterIndex + 4], charArray[characterIndex + 5]};
                            String hexString = new String(hexChars);
                            if (DIGITS_PATTERN.matcher(hexString).matches()) {
                                builder.append(c);
                                break;
                            }
                            if (policy != InvalidEscapeStringPolicy.SKIP) continue block8;
                            ++characterIndex;
                            break;
                        }
                        default: {
                            switch (policy) {
                                case SKIP: {
                                    ++characterIndex;
                                    break block0;
                                }
                                case UNESCAPE: {
                                    break block0;
                                }
                            }
                        }
                    }
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        };
    }

    private static Map<Column, String> createJsonPointerMap(Schema schema, SchemaConfig config) {
        HashMap<Column, String> result = new HashMap<Column, String>();
        List columns = schema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            ColumnConfig columnConfig = config.getColumn(i);
            OptionalColumnConfig options = (OptionalColumnConfig)CONFIG_MAPPER_FACTORY.createConfigMapper().map(columnConfig.getOption(), OptionalColumnConfig.class);
            if (!options.getElementAt().isPresent()) continue;
            result.put(column, options.getElementAt().get());
        }
        return result;
    }

    private static Map<Column, TimestampFormatter> newTimestampColumnFormattersAsMap(PluginTask task, SchemaConfig schema) {
        HashMap<Column, TimestampFormatter> formatters = new HashMap<Column, TimestampFormatter>();
        int i = 0;
        for (ColumnConfig column : schema.getColumns()) {
            if (column.getType() instanceof TimestampType) {
                OptionalColumnConfig option = (OptionalColumnConfig)CONFIG_MAPPER_FACTORY.createConfigMapper().map(column.getOption(), OptionalColumnConfig.class);
                String pattern = option.getFormat().orElse(task.getDefaultTimestampFormat());
                TimestampFormatter formatter = TimestampFormatter.builder((String)pattern, (boolean)true).setDefaultZoneFromString(option.getTimeZoneId().orElse(task.getDefaultTimeZoneId())).setDefaultDateFromString(option.getDate().orElse(task.getDefaultDate())).build();
                formatters.put(column.toColumn(i), formatter);
            }
            ++i;
        }
        return Collections.unmodifiableMap(formatters);
    }

    private static String asString(JsonValue value) {
        if (value.isJsonString()) {
            return value.asJsonString().getString();
        }
        return value.toString();
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    static class JsonRecordValidateException
    extends DataException {
        JsonRecordValidateException(String message) {
            super(message);
        }
    }

    public static interface OptionalColumnConfig
    extends Task {
        @Config(value="element_at")
        @ConfigDefault(value="null")
        public Optional<String> getElementAt();

        @Config(value="timezone")
        @ConfigDefault(value="null")
        public Optional<String> getTimeZoneId();

        @Config(value="format")
        @ConfigDefault(value="null")
        public Optional<String> getFormat();

        @Config(value="date")
        @ConfigDefault(value="null")
        public Optional<String> getDate();
    }

    public static interface PluginTask
    extends Task {
        @Config(value="stop_on_invalid_record")
        @ConfigDefault(value="false")
        public boolean getStopOnInvalidRecord();

        @Config(value="invalid_string_escapes")
        @ConfigDefault(value="\"PASSTHROUGH\"")
        public InvalidEscapeStringPolicy getInvalidEscapeStringPolicy();

        @Config(value="root")
        @ConfigDefault(value="null")
        public Optional<String> getRoot();

        @Config(value="flatten_json_array")
        @ConfigDefault(value="false")
        public boolean getFlattenJsonArray();

        @Config(value="columns")
        @ConfigDefault(value="null")
        public Optional<SchemaConfig> getSchemaConfig();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public String getDefaultTimeZoneId();

        @Config(value="default_timestamp_format")
        @ConfigDefault(value="\"%Y-%m-%d %H:%M:%S.%N %z\"")
        public String getDefaultTimestampFormat();

        @Config(value="default_date")
        @ConfigDefault(value="\"1970-01-01\"")
        public String getDefaultDate();
    }

    public static enum InvalidEscapeStringPolicy {
        PASSTHROUGH("PASSTHROUGH"),
        SKIP("SKIP"),
        UNESCAPE("UNESCAPE");

        private final String string;

        private InvalidEscapeStringPolicy(String string2) {
            this.string = string2;
        }

        public String getString() {
            return this.string;
        }
    }
}

