/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.config;

import java.util.List;
import java.util.Map;

public interface DataSource {
    public List<String> getAttributeNames();

    public boolean isEmpty();

    public boolean has(String var1);

    default public boolean hasList(String attrName) {
        if (!this.has(attrName)) {
            return false;
        }
        try {
            this.get(List.class, attrName);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    default public boolean hasNested(String attrName) {
        if (!this.has(attrName)) {
            return false;
        }
        try {
            this.getNested(attrName);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public <E> E get(Class<E> var1, String var2);

    public <E> E get(Class<E> var1, String var2, E var3);

    default public <E> List<E> getListOf(Class<E> type, String attrName) {
        return this.get(List.class, attrName);
    }

    public DataSource getNested(String var1);

    public DataSource getNestedOrSetEmpty(String var1);

    public DataSource getNestedOrGetEmpty(String var1);

    public DataSource set(String var1, Object var2);

    public DataSource setNested(String var1, DataSource var2);

    public DataSource setAll(DataSource var1);

    public DataSource remove(String var1);

    public DataSource deepCopy();

    public DataSource merge(DataSource var1);

    default public String toJson() {
        throw new UnsupportedOperationException("ConfigSource#toJson is not implemented with: " + this.getClass().getCanonicalName());
    }

    default public Map<String, Object> toMap() {
        throw new UnsupportedOperationException("ConfigSource#toMap is not implemented with: " + this.getClass().getCanonicalName());
    }
}

