/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.embulk.spi.json.JsonValue;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableArrayValueImpl;

public final class JsonArray
extends AbstractList<JsonValue>
implements JsonValue {
    private static final JsonArray EMPTY = new JsonArray(new JsonValue[0]);
    private final JsonValue[] values;
    private ImmutableArrayValueImpl msgpackArrayCache;

    private JsonArray(JsonValue[] values) {
        this.values = values;
        this.msgpackArrayCache = null;
    }

    private JsonArray(JsonValue[] values, ImmutableArrayValueImpl msgpackValue) {
        this.values = values;
        this.msgpackArrayCache = msgpackValue;
    }

    static JsonArray fromMsgpack(ArrayValue msgpackValue) {
        ImmutableArrayValueImpl immutable = (ImmutableArrayValueImpl)msgpackValue.immutableValue();
        int size = immutable.size();
        JsonValue[] values = new JsonValue[size];
        for (int i = 0; i < size; ++i) {
            values[i] = JsonValue.fromMsgpack(immutable.get(i));
        }
        return new JsonArray(values, immutable);
    }

    public static JsonArray of() {
        return EMPTY;
    }

    public static JsonArray of(JsonValue ... values) {
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        if (values.length == 0) {
            return EMPTY;
        }
        for (JsonValue value : values) {
            if (value != null) continue;
            throw new NullPointerException("values has null.");
        }
        return new JsonArray(Arrays.copyOf(values, values.length));
    }

    public static JsonArray ofList(List<? extends JsonValue> values) {
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        if (values.isEmpty()) {
            return EMPTY;
        }
        for (JsonValue jsonValue : values) {
            if (jsonValue != null) continue;
            throw new NullPointerException("values has null.");
        }
        return new JsonArray(values.toArray(new JsonValue[values.size()]));
    }

    public static JsonArray ofUnsafe(JsonValue ... array) {
        return new JsonArray(array);
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.ARRAY;
    }

    @Override
    public JsonArray asJsonArray() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        int sum = 4;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.values[i].presumeReferenceSizeInBytes();
        }
        return sum;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public JsonValue get(int index) {
        return this.values[index];
    }

    @Override
    public String toJson() {
        if (this.values.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.values[0].toJson());
        for (int i = 1; i < this.values.length; ++i) {
            builder.append(",");
            builder.append(this.values[i].toJson());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        if (this.msgpackArrayCache != null) {
            return this.msgpackArrayCache;
        }
        Value[] msgpackValues = new Value[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            msgpackValues[i] = this.values[i].toMsgpack();
        }
        this.msgpackArrayCache = new ImmutableArrayValueImpl(msgpackValues);
        return this.msgpackArrayCache;
    }

    @Override
    public String toString() {
        if (this.values.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.values[0].toString());
        for (int i = 1; i < this.values.length; ++i) {
            builder.append(",");
            builder.append(this.values[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof JsonArray)) {
            return false;
        }
        JsonArray other = (JsonArray)otherObject;
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            JsonValue value = this.values[i];
            hash = 31 * hash + value.hashCode();
        }
        return hash;
    }
}

