/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import org.embulk.spi.json.JsonValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableBooleanValueImpl;

public final class JsonBoolean
implements JsonValue {
    public static final JsonBoolean FALSE = new JsonBoolean(false);
    public static final JsonBoolean TRUE = new JsonBoolean(true);
    private final boolean value;

    private JsonBoolean(boolean value) {
        this.value = value;
    }

    public static JsonBoolean of(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.BOOLEAN;
    }

    @Override
    public JsonBoolean asJsonBoolean() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        return 1;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public String toJson() {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        if (this.value) {
            return ImmutableBooleanValueImpl.TRUE;
        }
        return ImmutableBooleanValueImpl.FALSE;
    }

    public String toString() {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public boolean equals(Object otherObject) {
        return this == FALSE && otherObject == FALSE || this == TRUE && otherObject == TRUE;
    }

    public int hashCode() {
        if (this.value) {
            return 1231;
        }
        return 1237;
    }
}

