/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.embulk.spi.json.JsonDouble;
import org.embulk.spi.json.JsonNumber;
import org.embulk.spi.json.JsonValue;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableLongValueImpl;

public final class JsonLong
implements JsonNumber {
    private final ImmutableLongValueImpl value;
    private final String literal;

    private JsonLong(long value, String literal) {
        this.value = new ImmutableLongValueImpl(value);
        this.literal = literal;
    }

    private JsonLong(ImmutableLongValueImpl msgpackValue) {
        this.value = msgpackValue;
        this.literal = null;
    }

    static JsonLong fromMsgpack(IntegerValue msgpackValue) {
        ImmutableIntegerValue immutableInteger = (ImmutableIntegerValue)msgpackValue.immutableValue();
        if (immutableInteger instanceof ImmutableLongValueImpl) {
            return new JsonLong((ImmutableLongValueImpl)immutableInteger);
        }
        throw new IllegalArgumentException("MessagePack's Integer type is not long.");
    }

    public static JsonLong of(long value) {
        return new JsonLong(value, null);
    }

    public static JsonLong withLiteral(long value, String literal) {
        return new JsonLong(value, literal);
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.LONG;
    }

    @Override
    public JsonLong asJsonLong() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        if (this.literal == null) {
            return 8;
        }
        return this.literal.length() * 2 + 8;
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public boolean isByteValue() {
        return this.value.isInByteRange();
    }

    @Override
    public boolean isShortValue() {
        return this.value.isInShortRange();
    }

    @Override
    public boolean isIntValue() {
        return this.value.isInIntRange();
    }

    @Override
    public boolean isLongValue() {
        return true;
    }

    @Override
    public byte byteValue() {
        return this.value.toByte();
    }

    @Override
    public byte byteValueExact() {
        if (!this.isByteValue()) {
            throw new ArithmeticException("Out of the range of byte: " + this.value);
        }
        return this.value.toByte();
    }

    @Override
    public short shortValue() {
        return this.value.toShort();
    }

    @Override
    public short shortValueExact() {
        if (!this.isShortValue()) {
            throw new ArithmeticException("Out of the range of short: " + this.value);
        }
        return this.value.toShort();
    }

    @Override
    public int intValue() {
        return this.value.toInt();
    }

    @Override
    public int intValueExact() {
        if (!this.isIntValue()) {
            throw new ArithmeticException("Out of the range of int: " + this.value);
        }
        return this.value.toInt();
    }

    @Override
    public long longValue() {
        return this.value.toLong();
    }

    @Override
    public long longValueExact() {
        return this.value.toLong();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.value.toBigInteger();
    }

    @Override
    public float floatValue() {
        return this.value.toFloat();
    }

    @Override
    public double doubleValue() {
        return this.value.toDouble();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value.toLong());
    }

    @Override
    public String toJson() {
        if (this.literal != null) {
            return this.literal;
        }
        return Long.toString(this.value.toLong());
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value.toLong());
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof JsonLong) {
            JsonLong other = (JsonLong)otherObject;
            return this.value.equals((Object)other.value);
        }
        if (otherObject instanceof JsonDouble) {
            JsonDouble other = (JsonDouble)otherObject;
            return other.isLongValue() && this.value.toLong() == other.longValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

