/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import org.embulk.spi.json.JsonArray;
import org.embulk.spi.json.JsonBoolean;
import org.embulk.spi.json.JsonDouble;
import org.embulk.spi.json.JsonLong;
import org.embulk.spi.json.JsonNull;
import org.embulk.spi.json.JsonObject;
import org.embulk.spi.json.JsonString;
import org.msgpack.value.Value;

public interface JsonValue {
    public EntityType getEntityType();

    default public boolean isJsonNull() {
        return this.getEntityType().isNull();
    }

    default public boolean isJsonBoolean() {
        return this.getEntityType().isBoolean();
    }

    default public boolean isJsonLong() {
        return this.getEntityType().isLong();
    }

    default public boolean isJsonDouble() {
        return this.getEntityType().isDouble();
    }

    default public boolean isJsonString() {
        return this.getEntityType().isString();
    }

    default public boolean isJsonArray() {
        return this.getEntityType().isArray();
    }

    default public boolean isJsonObject() {
        return this.getEntityType().isObject();
    }

    default public JsonNull asJsonNull() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonNull.");
    }

    default public JsonBoolean asJsonBoolean() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonBoolean.");
    }

    default public JsonLong asJsonLong() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonLong.");
    }

    default public JsonDouble asJsonDouble() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonDouble.");
    }

    default public JsonString asJsonString() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonString.");
    }

    default public JsonArray asJsonArray() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonArray.");
    }

    default public JsonObject asJsonObject() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to JsonObject.");
    }

    public int presumeReferenceSizeInBytes();

    public String toJson();

    @Deprecated
    public Value toMsgpack();

    @Deprecated
    public static JsonValue fromMsgpack(Value msgpackValue) {
        if (msgpackValue == null) {
            throw new NullPointerException("msgpackValue is null.");
        }
        switch (msgpackValue.getValueType()) {
            case NIL: {
                return JsonNull.NULL;
            }
            case BOOLEAN: {
                if (msgpackValue.asBooleanValue().getBoolean()) {
                    return JsonBoolean.TRUE;
                }
                return JsonBoolean.FALSE;
            }
            case INTEGER: {
                return JsonLong.fromMsgpack(msgpackValue.asIntegerValue());
            }
            case FLOAT: {
                return JsonDouble.fromMsgpack(msgpackValue.asFloatValue());
            }
            case STRING: {
                return JsonString.fromMsgpack(msgpackValue.asStringValue());
            }
            case BINARY: {
                throw new IllegalArgumentException("MessagePack's Binary type is not supported.");
            }
            case ARRAY: {
                return JsonArray.fromMsgpack(msgpackValue.asArrayValue());
            }
            case MAP: {
                return JsonObject.fromMsgpack(msgpackValue.asMapValue());
            }
            case EXTENSION: {
                throw new IllegalArgumentException("MessagePack's Extension type is not supported.");
            }
        }
        throw new IllegalArgumentException("MessagePack's type is unknown.");
    }

    public static enum EntityType {
        NULL,
        BOOLEAN,
        LONG,
        DOUBLE,
        STRING,
        ARRAY,
        OBJECT;


        public boolean isNull() {
            return this == NULL;
        }

        public boolean isBoolean() {
            return this == BOOLEAN;
        }

        public boolean isLong() {
            return this == LONG;
        }

        public boolean isDouble() {
            return this == DOUBLE;
        }

        public boolean isString() {
            return this == STRING;
        }

        public boolean isArray() {
            return this == ARRAY;
        }

        public boolean isObject() {
            return this == OBJECT;
        }
    }
}

