/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.aws.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.embulk.config.ConfigException;
import org.embulk.util.aws.credentials.AwsCredentialsConfig;
import org.embulk.util.aws.credentials.AwsCredentialsTask;
import org.embulk.util.aws.credentials.AwsCredentialsTaskWithPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsCredentials {
    private static final Logger log = LoggerFactory.getLogger(AwsCredentials.class);
    private static final String ARN_PATTERN = "arn:%s:iam::%s:role/%s";

    private AwsCredentials() {
    }

    public static AWSCredentialsProvider getAWSCredentialsProvider(AwsCredentialsTaskWithPrefix task) {
        return AwsCredentials.getAWSCredentialsProvider("aws_", task);
    }

    public static AWSCredentialsProvider getAWSCredentialsProvider(AwsCredentialsTask task) {
        return AwsCredentials.getAWSCredentialsProvider("", task);
    }

    private static AWSCredentialsProvider getAWSCredentialsProvider(String prefix, AwsCredentialsConfig task) {
        String authMethodOption = prefix + "auth_method";
        String sessionTokenOption = prefix + "session_token";
        String profileFileOption = prefix + "profile_file";
        String profileNameOption = prefix + "profile_name";
        String accessKeyIdOption = prefix + "access_key_id";
        String secretAccessKeyOption = prefix + "secret_access_key";
        String accountIdOption = prefix + "account_id";
        String roleNameOption = prefix + "role_name";
        String externalIdOption = prefix + "external_id";
        switch (task.getAuthMethod()) {
            case "basic": {
                if (!task.getAccessKeyId().isPresent() && !task.getAccessKeyId().isPresent()) {
                    log.warn("Both '{}' and '{}' are not set. Assuming that '{}: anonymous' option is set.", new Object[]{accessKeyIdOption, secretAccessKeyOption, authMethodOption});
                    log.warn("If you intentionally use anonymous authentication, please set 'auth_method: anonymous' option.");
                    log.warn("This behavior will be removed in a future release.");
                    AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                    AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                    AwsCredentials.reject(task.getProfileName(), profileNameOption);
                    AwsCredentials.reject(task.getAccountId(), accountIdOption);
                    AwsCredentials.reject(task.getRoleName(), roleNameOption);
                    AwsCredentials.reject(task.getExternalId(), externalIdOption);
                    return new AWSCredentialsProvider(){

                        public AWSCredentials getCredentials() {
                            return new AnonymousAWSCredentials();
                        }

                        public void refresh() {
                        }
                    };
                }
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                String accessKeyId = AwsCredentials.require(task.getAccessKeyId(), "'access_key_id', 'secret_access_key'");
                String secretAccessKey = AwsCredentials.require(task.getSecretAccessKey(), "'secret_access_key'");
                final BasicAWSCredentials creds = new BasicAWSCredentials(accessKeyId, secretAccessKey);
                return new AWSCredentialsProvider(){

                    public AWSCredentials getCredentials() {
                        return creds;
                    }

                    public void refresh() {
                    }
                };
            }
            case "env": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                return AwsCredentials.overwriteBasicCredentials(task, new EnvironmentVariableCredentialsProvider().getCredentials());
            }
            case "instance": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                return AwsCredentials.createInstanceProfileCredentialsProvider();
            }
            case "profile": {
                ProfileCredentialsProvider provider;
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                String profileName = task.getProfileName().orElse("default");
                if (task.getProfileFile().isPresent()) {
                    Path profileFilePath = Paths.get(task.getProfileFile().get(), new String[0]);
                    ProfilesConfigFile file = new ProfilesConfigFile(profileFilePath.toFile());
                    provider = new ProfileCredentialsProvider(file, profileName);
                } else {
                    provider = new ProfileCredentialsProvider(profileName);
                }
                return AwsCredentials.overwriteBasicCredentials(task, provider.getCredentials());
            }
            case "properties": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                return AwsCredentials.overwriteBasicCredentials(task, new SystemPropertiesCredentialsProvider().getCredentials());
            }
            case "anonymous": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                return new AWSCredentialsProvider(){

                    public AWSCredentials getCredentials() {
                        return new AnonymousAWSCredentials();
                    }

                    public void refresh() {
                    }
                };
            }
            case "session": {
                String accessKeyId = AwsCredentials.require(task.getAccessKeyId(), "'" + accessKeyIdOption + "', '" + secretAccessKeyOption + "', '" + sessionTokenOption + "'");
                String secretAccessKey = AwsCredentials.require(task.getSecretAccessKey(), "'" + secretAccessKeyOption + "', '" + sessionTokenOption + "'");
                String sessionToken = AwsCredentials.require(task.getSessionToken(), "'" + sessionTokenOption + "'");
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                BasicSessionCredentials creds = new BasicSessionCredentials(accessKeyId, secretAccessKey, sessionToken);
                return new AWSSessionCredentialsProvider((AWSSessionCredentials)creds){
                    final /* synthetic */ AWSSessionCredentials val$creds;
                    {
                        this.val$creds = aWSSessionCredentials;
                    }

                    public AWSSessionCredentials getCredentials() {
                        return this.val$creds;
                    }

                    public void refresh() {
                    }
                };
            }
            case "assume_role": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                String accountId = AwsCredentials.require(task.getAccountId(), "'" + accountIdOption + "'");
                String roleName = AwsCredentials.require(task.getRoleName(), "'" + roleNameOption + "'");
                String externalId = AwsCredentials.require(task.getExternalId(), "'" + externalIdOption + "'");
                String arn = String.format(ARN_PATTERN, task.getArnPartition(), accountId, roleName);
                STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(arn, task.getSessionName());
                return builder.withExternalId(externalId).withRoleSessionDurationSeconds(task.getDurationInSeconds()).build();
            }
            case "default": {
                AwsCredentials.reject(task.getAccessKeyId(), accessKeyIdOption);
                AwsCredentials.reject(task.getSecretAccessKey(), secretAccessKeyOption);
                AwsCredentials.reject(task.getSessionToken(), sessionTokenOption);
                AwsCredentials.reject(task.getProfileFile(), profileFileOption);
                AwsCredentials.reject(task.getProfileName(), profileNameOption);
                AwsCredentials.reject(task.getAccountId(), accountIdOption);
                AwsCredentials.reject(task.getRoleName(), roleNameOption);
                AwsCredentials.reject(task.getExternalId(), externalIdOption);
                return new DefaultAWSCredentialsProviderChain();
            }
        }
        throw new ConfigException(String.format("Unknown auth_method '%s'. Supported methods are basic, instance, profile, properties, anonymous, session and default.", task.getAuthMethod()));
    }

    private static AWSCredentialsProvider overwriteBasicCredentials(AwsCredentialsConfig task, final AWSCredentials creds) {
        return new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return creds;
            }

            public void refresh() {
            }
        };
    }

    private static <T> T require(Optional<T> value, String message) {
        if (value.isPresent()) {
            return value.get();
        }
        throw new ConfigException("Required option is not set: " + message);
    }

    private static <T> void reject(Optional<T> value, String message) {
        if (value.isPresent()) {
            throw new ConfigException("Invalid option is set: " + message);
        }
    }

    private static InstanceProfileCredentialsProvider createInstanceProfileCredentialsProvider() {
        return new InstanceProfileCredentialsProvider();
    }
}

