/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Validator;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskInvocationHandler;
import org.embulk.util.config.TaskObjectsRetriever;

final class ConfigTaskDeserializer<T extends Task>
extends JsonDeserializer<T> {
    private final Class<? extends Task> taskInterface;
    private final TaskObjectsRetriever taskObjectsRetriever;
    private final ObjectMapper nestedObjectMapper;
    private final Validator validator;

    ConfigTaskDeserializer(Class<T> taskInterface, TaskObjectsRetriever taskObjectsRetriever, ObjectMapper nestedObjectMapper, Validator validator) {
        this.taskInterface = taskInterface;
        this.taskObjectsRetriever = taskObjectsRetriever;
        this.nestedObjectMapper = nestedObjectMapper;
        this.validator = validator;
    }

    public final T deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ConcurrentHashMap<String, Object> internalObjects = this.taskObjectsRetriever.buildTaskBackingObjects(jsonParser);
        return this.castToT(Proxy.newProxyInstance(this.taskInterface.getClassLoader(), new Class[]{this.taskInterface}, (InvocationHandler)new TaskInvocationHandler(this.taskInterface, internalObjects, this.nestedObjectMapper, this.validator)));
    }

    private T castToT(Object proxy) {
        return (T)((Task)proxy);
    }
}

