/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.embulk.config.DataSource;
import org.embulk.util.config.DataSourceImpl;

final class DataSourceDeserializer<T extends DataSource>
extends JsonDeserializer<T> {
    private final ObjectMapper nestedObjectMapper;
    private final ObjectMapper treeObjectMapper;

    DataSourceDeserializer(ObjectMapper nestedObjectMapper) {
        this.nestedObjectMapper = nestedObjectMapper;
        this.treeObjectMapper = new ObjectMapper();
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode json = (JsonNode)this.treeObjectMapper.readTree(jsonParser);
        if (!json.isObject()) {
            throw new JsonMappingException("Expected object to deserialize DataSource", jsonParser.getCurrentLocation());
        }
        return this.castToT(new DataSourceImpl((ObjectNode)json, this.nestedObjectMapper));
    }

    private T castToT(DataSourceImpl data) {
        return (T)data;
    }
}

