/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.embulk.util.config.GenericTypeReference;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskField;

final class TaskObjectsRetriever {
    private final Class<? extends Task> taskInterface;
    private final Map<String, List<TaskField>> taskFieldsFromJsonFieldName;
    private final boolean useDefault;
    private final ObjectMapper nestedObjectMapper;

    private TaskObjectsRetriever(Class<? extends Task> taskInterface, Map<String, List<TaskField>> taskFieldsFromJsonFieldName, boolean useDefault, ObjectMapper nestedObjectMapper) {
        this.taskInterface = taskInterface;
        this.taskFieldsFromJsonFieldName = taskFieldsFromJsonFieldName;
        this.useDefault = useDefault;
        this.nestedObjectMapper = nestedObjectMapper;
    }

    static final TaskObjectsRetriever forConfig(Class<? extends Task> taskInterface, ObjectMapper nestedObjectMapper) {
        return new TaskObjectsRetriever(taskInterface, TaskObjectsRetriever.mapTaskFieldsFromJsonFieldName(taskInterface, taskField -> taskField.getFieldNameMappedFromConfigSourceJson()), true, nestedObjectMapper);
    }

    static final TaskObjectsRetriever forTask(Class<? extends Task> taskInterface, ObjectMapper nestedObjectMapper) {
        return new TaskObjectsRetriever(taskInterface, TaskObjectsRetriever.mapTaskFieldsFromJsonFieldName(taskInterface, taskField -> taskField.getFieldNameMappedFromTaskSourceJson()), false, nestedObjectMapper);
    }

    final ConcurrentHashMap<String, Object> buildTaskBackingObjects(JsonParser parser) throws IOException {
        HashMap<TaskField, String> unfilledTaskFields = new HashMap<TaskField, String>();
        for (Map.Entry<String, List<TaskField>> sourceJsonKeyAndTaskFields : this.taskFieldsFromJsonFieldName.entrySet()) {
            String sourceJsonKey = sourceJsonKeyAndTaskFields.getKey();
            for (TaskField taskField : sourceJsonKeyAndTaskFields.getValue()) {
                unfilledTaskFields.put(taskField, sourceJsonKey);
            }
        }
        ArrayList<NullPointerException> nullExceptions = new ArrayList<NullPointerException>();
        ConcurrentHashMap<String, Object> taskBackingObjects = this.buildTaskBackingObjectsOnlyAvailableInJson(parser, unfilledTaskFields, nullExceptions);
        for (Map.Entry entry : unfilledTaskFields.entrySet()) {
            TaskField unfilledTaskField = (TaskField)entry.getKey();
            String key = (String)entry.getValue();
            if (this.useDefault && unfilledTaskField.getDefaultValueInJsonString().isPresent()) {
                Object value = this.nestedObjectMapper.readValue(unfilledTaskField.getDefaultValueInJsonString().get(), (TypeReference)new GenericTypeReference(unfilledTaskField.getReturnType()));
                if (value == null) {
                    nullExceptions.add(new NullPointerException("Setting null to a task field is not allowed: " + key + ". " + unfilledTaskField.getGetterMethod().getName() + "() has to use java.util.Optional<T> to represent null."));
                    continue;
                }
                taskBackingObjects.put(unfilledTaskField.getName(), value);
                continue;
            }
            throw JsonMappingException.from((JsonParser)parser, (String)("Field '" + key + "' is required but not set."));
        }
        if (!nullExceptions.isEmpty()) {
            JsonMappingException ex = new JsonMappingException("Setting null to a task field is not allowed.");
            for (NullPointerException inner : nullExceptions) {
                ex.addSuppressed((Throwable)inner);
            }
            throw ex;
        }
        return taskBackingObjects;
    }

    private ConcurrentHashMap<String, Object> buildTaskBackingObjectsOnlyAvailableInJson(JsonParser parser, HashMap<TaskField, String> unfilledTaskFields, ArrayList<NullPointerException> nullExceptions) throws IOException {
        String firstKey;
        ConcurrentHashMap<String, Object> taskBackingObjects = new ConcurrentHashMap<String, Object>();
        if (JsonToken.START_OBJECT == parser.getCurrentToken()) {
            JsonToken dummy = parser.nextToken();
            firstKey = parser.getCurrentName();
        } else {
            firstKey = parser.nextFieldName();
        }
        String key = firstKey;
        while (key != null) {
            JsonToken dummy = parser.nextToken();
            List<TaskField> taskFieldsForKey = this.taskFieldsFromJsonFieldName.get(key);
            if (taskFieldsForKey == null || taskFieldsForKey.isEmpty()) {
                parser.skipChildren();
            } else {
                JsonNode children = (JsonNode)this.nestedObjectMapper.readValue(parser, JsonNode.class);
                for (TaskField taskField : taskFieldsForKey) {
                    Object value = this.nestedObjectMapper.convertValue((Object)children, (TypeReference)new GenericTypeReference(taskField.getReturnType()));
                    if (value == null) {
                        nullExceptions.add(new NullPointerException("Setting null to a task field is not allowed: " + key + ". " + taskField.getGetterMethod().getName() + "() has to use java.util.Optional<T> to represent null."));
                    } else {
                        taskBackingObjects.put(taskField.getName(), value);
                    }
                    if (unfilledTaskFields.remove(taskField, key)) continue;
                    throw new JsonMappingException(String.format("FATAL: Expected to be a bug in embulk-util-config. Mapping \"%s: (%s) %s\" might have already been processed, or not in %s.", key, taskField.getReturnType().toString(), taskField.getName(), this.taskInterface.toString()));
                }
            }
            key = parser.nextFieldName();
        }
        return taskBackingObjects;
    }

    private static Map<String, List<TaskField>> mapTaskFieldsFromJsonFieldName(Class<? extends Task> taskInterface, Function<TaskField, String> getFieldNameMappedFromSourceJson) {
        ConcurrentHashMap<String, List> taskFieldsFromJsonFieldName = new ConcurrentHashMap<String, List>();
        for (Method method : taskInterface.getMethods()) {
            String keyExpectedInSourceJson;
            TaskField taskField = TaskField.of(method);
            if (taskField == null || (keyExpectedInSourceJson = getFieldNameMappedFromSourceJson.apply(taskField)) == null) continue;
            taskFieldsFromJsonFieldName.compute(keyExpectedInSourceJson, (key, oldValue) -> {
                if (oldValue == null) {
                    ArrayList<TaskField> newValue = new ArrayList<TaskField>();
                    newValue.add(taskField);
                    return newValue;
                }
                oldValue.add(taskField);
                return oldValue;
            });
        }
        taskFieldsFromJsonFieldName.replaceAll((key, value) -> Collections.unmodifiableList(value));
        return Collections.unmodifiableMap(taskFieldsFromJsonFieldName);
    }
}

