/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.config;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.embulk.config.DataSource;
import org.embulk.util.config.Compat;

final class DataSourceSerializer<T extends DataSource>
extends JsonSerializer<T> {
    private final ObjectMapper nestedObjectMapper;

    DataSourceSerializer(ObjectMapper nestedObjectMapper) {
        this.nestedObjectMapper = nestedObjectMapper;
    }

    public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String valueJsonStringified;
        if (value == null) {
            throw new JsonGenerationException((Throwable)new NullPointerException("DataSourceSerializer#serialize accepts only non-null value."));
        }
        try {
            valueJsonStringified = Compat.toJson(value);
        }
        catch (IOException ex) {
            throw new JsonGenerationException("Unexpected failure in stringifying DataSource as JSON.", (Throwable)ex);
        }
        if (valueJsonStringified == null) {
            throw new JsonGenerationException((Throwable)new NullPointerException("DataSourceSerializer#serialize accepts only valid DataSource."));
        }
        JsonNode valueJsonNode = (JsonNode)this.nestedObjectMapper.readValue(valueJsonStringified, JsonNode.class);
        if (!valueJsonNode.isObject()) {
            throw new JsonGenerationException((Throwable)new ClassCastException("DataSourceSerializer#serialize accepts only valid JSON object."));
        }
        ((ObjectNode)valueJsonNode).serialize(jsonGenerator, serializerProvider);
    }
}

